package com.digiwin.athena.cdme.core.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;

/**
 * @description: 适用于操作数据访问时异常的场景。例如：对DB、cache的CRUD的操作。
 * @author: dongwh
 * @date: 2022/1/6 14:57
 */
public class RepositoryException extends DWRuntimeException implements Retryable {

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     * @param errorCodeEnum 错误码枚举
     */
    public RepositoryException(ErrorCodeEnum errorCodeEnum) {
        super(errorCodeEnum.getCode(), errorCodeEnum.getMessage());
    }
    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public RepositoryException(String message) {
        super(message);
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public RepositoryException(String message, Throwable cause) {
        super(message, cause);
    }
}
