package com.digiwin.athena.cdme.core.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;

/**
 * @description: 适用于标记了@Transactional注解的方法中抛出的自定义异常。
 * @author: dongwh
 * @date: 2022/1/6 14:54
 */
public class RollbackException extends DWRuntimeException implements Retryable {

    /**
     * 构造一个基本异常.
     * @param errorCodeEnum 错误码枚举
     */
    public RollbackException(ErrorCodeEnum errorCodeEnum) {
        super(errorCodeEnum.getCode(), errorCodeEnum.getMessage());
    }

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public RollbackException(String message) {
        super(message);
    }

    /**
     * 构造一个基本异常.
     * @param message 错误码
     * @param message 信息描述
     */
    public RollbackException(String errorCode, String message) {
        super(errorCode, message);
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public RollbackException(String message, Throwable cause) {
        super(message, cause);
    }

}
