package com.digiwin.athena.cdme.core.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;

/**
 * @description: 平台API返回结果处理工具
 * @author: liunansheng
 * @date: 2021/10/22 11:27
 */
public final class DWResponseUtil {
    private DWResponseUtil() {
    }

    public static ResultDto<JSONObject> convertResponse(JSONObject httpRespOjb) {
        return convertResponse(httpRespOjb, JSONObject.class);
    }

    public static <T> ResultDto<T> convertResponse(JSONObject httpRespOjb, Class<T> cls) {
        if (CollectionUtil.isNotEmpty(httpRespOjb) && FieldValConstant.RESPONSE_SUCCESS_CODE == httpRespOjb.getIntValue(FieldConstant.DW_SERVICE_STATUS)) {
            T response = httpRespOjb.getObject(FieldConstant.DW_SERVICE_RESPONSE, cls);
            return ResultHelper.generateSuccessResult(response);
        } else if (null == httpRespOjb) {
            return ResultHelper.generateFailResult("返回数据为空");
        } else {
            return ResultHelper.generateFailResult(httpRespOjb.getString(FieldConstant.DW_SERVICE_ERRORMESSAGE));
        }
    }
}
