package com.digiwin.athena.cdme.core.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;

/**
 * @author renwm
 * @date: 2020/4/29 19:15
 */
public final class SecurityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtil.class);
    private static final String ALGORITHM = DWApplicationConfigUtils.getProperty("cdme.SecurityUtil.ALGORITHM");
    private static final String CIPHER_TRANSFORMATION = DWApplicationConfigUtils.getProperty("cdme.SecurityUtil.CIPHER_TRANSFORMATION");

    private SecurityUtil() {
    }

    /**
     * @param
     * @return 密钥 = "C40605DBA4C2D6D3FA353C7CA35752B9";
     * secretFile = "53FA99EB3E4DA6AFE37DBD06F366FB6B";
     * 解密后:fafdsfasf
     */
    public static String decodeAES(String secretFile) {
        byte[] result = {};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        try {
            Key key1 = new SecretKeySpec(Hex.decodeHex(secretKey), "AES");

            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(Cipher.DECRYPT_MODE, key1);
            result = cipher.doFinal(Hex.decodeHex(secretFile));
        } catch (Exception e) {
            LOGGER.error("字符串" + secretFile + "使用decodeAES解密请求失败", e);
        }

        return new String(result);
    }

    /**
     * MD5加密
     *
     * @param inputStr
     * @return
     */
    public static String getMd5Result(String inputStr) {
        String encode = "";
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            byte[] inputData = inputStr.getBytes();
            md.update(inputData);
            BigInteger bigInteger = new BigInteger(md.digest());
            encode = Base64.getEncoder().encodeToString(bigInteger.toString(64).getBytes(StandardCharsets.UTF_8));
        } catch (Exception e) {
            LOGGER.error("字符串" + inputStr + "使用MD5加密请求失败", e);
        }
        return encode;
    }

    public static String getMd5Hex(String inputStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            return Hex.encodeHexString(md.digest(StringUtils.getBytesUtf8(inputStr)));
        } catch (Exception e) {
            LOGGER.error("字符串" + inputStr + "使用MD5加密返回hex失败", e);
        }
        return result;
    }

    /**
     *  true：表示当前环境为生产环境且secure验证正确或当前环境为非生产环境
     *  false：表示当前环境为生产环境但secure验证不通过
     *
     * @param secure
     * @param type
     * @return
     */
    public static boolean isEnvValid(String secure, String type) {
        if (!isProdEnv()) {
            return true;
        }

        return verifySecure(secure, type);
    }

    /**
     * 检查当前环境是否是生产环境
     *
     * @return
     */
    private static boolean isProdEnv() {
        return ConfigConstant.THEMEMAP_DOMAIN_URL.contains("thememap.apps.digiwincloudlocal");
    }

    /**
     * 校验传入的secure是否正确
     *
     * @param secure
     * @param type
     * @return
     */
    public static boolean verifySecure(String secure, String type) {
        if (StringUtil.isBlank(secure)) {
            LOGGER.info("入参secure不能为空");
            return false;
        }
        /** 当前日期 */
        String currentTime = LocalTimeUtil.getCurrentDate(true);
        String md5Interference = "";
        if (FieldConstant.SECURE_TYPE_MONITOROPS.equals(type)) {
            md5Interference = ConfigConstant.MONITOR_INFO_MD5_KEY;
        } else if (FieldConstant.SECURE_TYPE_REDISOPS.equals(type)) {
            md5Interference = ConfigConstant.REDIS_MD5_KEY;
        }
        /** 当前日期使用md5加密后是否和secure相同 */
        String md5Result = SecurityUtil.getMd5Result(currentTime + md5Interference);
        if (MessageDigest.isEqual(md5Result.getBytes(),secure.getBytes())) {
            return true;
        } else {
            LOGGER.info("验证失败,无权限操作！");
            return false;
        }
    }
}
