package com.digiwin.athena.cdme.mq.consumer.rule;

import com.digiwin.athena.cdme.core.exception.Retryable;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.service.client.impl.ThemeMapClient;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/2/28 10:59
 */
@Service("cdmeRuleSyncCallBack")
public class RuleSyncCallBack {

    private final ThemeMapClient themeMapClient;

    public RuleSyncCallBack(ThemeMapClient themeMapClient) {
        this.themeMapClient = themeMapClient;
    }

    /**
     * 同步成功回调
     * @param transactionId
     * @param ruleId
     */
    public void successCallBack(String transactionId, String ruleId) {
        if (StringUtil.isNotBlank(transactionId)) {
            themeMapClient.syncRuleCallBack(transactionId, ruleId, true, null);
        }
    }

    /**
     * 异常回调
     */
    public void failCallBack(String transactionId, String ruleId, Throwable e, Message message) {
        boolean isRetry = e instanceof Retryable;
        boolean requeue = message.getMessageProperties() != null && BooleanUtils.isFalse(message.getMessageProperties().getRedelivered());
        /**不需要重试或者最后一次重试则回调失败结果*/
        if ((!isRetry || !requeue) && StringUtil.isNotBlank(transactionId)) {
            String msg = StringUtil.isNotBlank(e.getMessage()) ? e.getMessage() : "系统异常";
            themeMapClient.syncRuleCallBack(transactionId, ruleId, false, msg);
        }
    }
}
