package com.digiwin.athena.cdme.pojo.bo;

import com.digiwin.athena.cdme.pojo.BaseEntity;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.TimeRangeDto;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;

import java.time.LocalDateTime;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/3 13:18
 */
public class EocTimeRangeBO extends BaseEntity {

    private EocDto eoc;

    private TimeRangeDto timeRange;

    private MonitorTriggerInsModel ins;

    public EocTimeRangeBO(EocDto eoc, LocalDateTime startTime, LocalDateTime endTime, MonitorTriggerInsModel ins) {
        this.eoc = eoc;
        this.timeRange = new TimeRangeDto(startTime, endTime);
        this.ins = ins;
    }

    public EocTimeRangeBO() {
    }

    public EocDto getEoc() {
        return eoc;
    }

    public void setEoc(EocDto eoc) {
        this.eoc = eoc;
    }

    public LocalDateTime getStartTime() {
        return null == timeRange ? null : timeRange.getStartTime();
    }

    public LocalDateTime getEndTime() {
        return null == timeRange ? null : timeRange.getEndTime();
    }

    public MonitorTriggerInsModel getIns() {
        return ins;
    }

    public void setIns(MonitorTriggerInsModel ins) {
        this.ins = ins;
    }

    public TimeRangeDto getTimeRange() {
        return timeRange;
    }

    public void setTimeRange(TimeRangeDto timeRange) {
        this.timeRange = timeRange;
    }

    public boolean isIllegal() {
        return timeRange.isIllegal();
    }

}
