package com.digiwin.athena.cdme.pojo.dto;

import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.BaseEntity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/3/7 16:16
 */
public class EocDto extends BaseEntity {
    private static final int COMPANY_WEIGHT = 3;
    private static final int SITE_WEIGHT = 5;
    private static final int REGION_WEIGHT = 7;

    private String eocCompanyId;
    private String eocSiteId;
    private String eocRegionId;

    public EocDto() {
    }

    public EocDto(String eocCompanyId, String eocSiteId, String eocRegionId) {
        this.eocCompanyId = eocCompanyId;
        this.eocSiteId = eocSiteId;
        this.eocRegionId = eocRegionId;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getEocRegionId() {
        return eocRegionId;
    }

    public void setEocRegionId(String eocRegionId) {
        this.eocRegionId = eocRegionId;
    }

    public Map<String, Object> toUnderLineMap() {
        Map<String, Object> eocMap = new HashMap<>(4);
        if (StringUtil.isNotBlank(this.eocCompanyId)) {
            eocMap.put(FieldConstant.EOC_COMPANY_ID, this.eocCompanyId);
        }
        if (StringUtil.isNotBlank(this.eocSiteId)) {
            eocMap.put(FieldConstant.EOC_SITE_ID, this.eocSiteId);
        }
        if (StringUtil.isNotBlank(this.eocRegionId)) {
            eocMap.put(FieldConstant.EOC_REGION_ID, this.eocRegionId);
        }
        return eocMap;
    }

    public int calculateWeight() {
        int result = 0;
        if (StringUtil.isNotBlank(this.eocCompanyId)) {
            result += COMPANY_WEIGHT;
        }

        if (StringUtil.isNotBlank(this.eocSiteId)) {
            result += SITE_WEIGHT;
        }

        if (StringUtil.isNotBlank(this.eocRegionId)) {
            result += REGION_WEIGHT;
        }

        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EocDto eocDto = (EocDto) o;
        return Objects.equals(eocCompanyId, eocDto.eocCompanyId) &&
                Objects.equals(eocSiteId, eocDto.eocSiteId) &&
                Objects.equals(eocRegionId, eocDto.eocRegionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(eocCompanyId, eocSiteId, eocRegionId);
    }
}
