package com.digiwin.athena.cdme.provider;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestBody;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.cdme.pojo.request.ReportRequest;
import com.digiwin.athena.cdme.pojo.request.RuleKeyRequest;

/**
 * @description: 发起侦测接口
 * @author: liunansheng
 * @date: 2022/4/2 15:32
 */
@DWRestfulService
public interface IDetectionService extends DWService {

    /**
     * 侦测数据并执行
     *
     * @param request
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "detect/execute", method = DWRequestMethod.POST)
    JSONArray detectAndExecute(@DWRequestBody RuleKeyRequest request);

    /**
     * 侦测数据并执行
     *
     * @param request
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "detect/report", method = DWRequestMethod.POST)
    String executeData(@DWRequestBody ReportRequest request);
}
