package com.digiwin.athena.cdme.provider;

import com.digiwin.app.service.DWService;
import java.util.Map;

/**
 * @description: redis服务接口
 * @author: dongwh
 * @date: 2020/7/21 14:27
 */
public interface IOptRedisService extends DWService {

    /**
     * 清除缓存
     *
     * @param param
     * @return
     * @throws Exception
     */
    String postCleanCache(Map<String, Object> param);

    /**
     * 读取缓存
     *
     * @param param
     * @return
     * @throws Exception
     */
    String postReadCache(Map<String, Object> param);

    /**
     * 设置缓存
     *
     * @param param
     * @return
     * @throws Exception
     */
    String postSetCache(Map<String, Object> param);

//    /**
//     * 获取通配符匹配的所有key
//     * @param pattern 通配符
//     * @param secure 秘钥
//     * @return
//     */
//    Set<String> postKeysByPattern(String pattern, String secure);
//
//    /**
//     * 根据通配符清除所有的key
//     * @param pattern 通配符
//     * @param secure 秘钥
//     */
//    String postDeleteKeysByPattern(String pattern, String secure);

    /**
     * 测试租户清除redis数据
     * @param param
     * @param tenantId
     * @return
     */
    String postCleanCache(Map<String, Object> param, String tenantId);


    /**
     * 测试租户读取redis数据
     * @param param
     * @param tenantId
     * @return
     */
    String postReadCache(Map<String, Object> param, String tenantId);

    /**
     * 设置测试租户redis缓存数据
     * @param param
     * @param tenantId
     * @return
     */
    String postSetCache(Map<String, Object> param, String tenantId);

    /**
     * 读取规则缓存
     *
     * @param param
     * @return
     * @throws Exception
     */
    String postReadRuleCache(Map<String, Object> param);

    /**
     * 删除规则缓存
     * @param param
     * @return
     */
    String postCleanRuleCache(Map<String, Object> param);

}
