package com.digiwin.athena.cdme.repository.model;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;

import java.time.LocalDateTime;

/**
 * @description: 侦测规则实体类
 * @author: renwm
 * @date: 2020/4/28 13:48
 */
@TableName("sd_monitor_rule_cdc")
public class MonitorRuleCdcModel {

    /** 主键ID */
    @TableId(type = IdType.AUTO)
    private Long kid;
    /** 规则ID */
    private String ruleId;
    /** 租户ID */
    private String tenantId;
    /** 租户SID */
    private String tenantSid;
    /** eoc公司ID */
    private String eocCompanyId;
    /** eoc工厂ID */
    private String eocSiteId;
    /** 被侦测表名 */
    private String tableName;
    /** 数据变更类型 create/update/delete */
    private String changeType;
    /** type为update时需要关注的变化的字段 逗号分隔 AND关系 */
    private String changeFields;
    /** 侦测到的记录返回的字段 */
    private String actionParams;
    /** 过滤条件（条件对应变化后数据） */
    private String filterCondition;
    /** 侦测到数据后续发起的服务编号 */
    private String actionId;
    /** 侦测到数据后续发起的服务类型 datapulling/task/serviceComposer */
    private String actionType;
    /** 地端erp产品名称 */
    private String productName;
    /** cdc侦测开关 DISABLED 关闭 ENABLED 运行 */
    private String valid;
    /** 侦测开始处理时间 */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    private LocalDateTime startTime;
    /** 创建时间 */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    private LocalDateTime createTime;
    /** 更新时间 */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    private LocalDateTime updateTime;

    /** 侦测类型 */
    private String category;

    /** 侦测来源 */
    private String dbName;

    /** MQTT侦测条件 */
    private String conversionFilterCondition;

    public MonitorRuleCdcModel() {

    }

    public MonitorRuleCdcModel(JSONObject ruleObj) {
        this.valid = FieldValConstant.RULE_ENABLE;
        this.ruleId = ruleObj.getString(FieldConstant.RULE_ID);
        this.tenantId = ruleObj.getString(FieldConstant.TENANT_ID);
        this.actionId = ruleObj.getString(FieldConstant.ACTION_ID);
        this.actionType = ruleObj.getString(FieldConstant.ACTION_TYPE);
        this.productName = ruleObj.getString(FieldConstant.PRODUCT_NAME);
    }

    public Long getKid() {
        return kid;
    }

    public void setKid(Long kid) {
        this.kid = kid;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getChangeFields() {
        return changeFields;
    }

    public void setChangeFields(String changeFields) {
        this.changeFields = changeFields;
    }

    public String getActionParams() {
        return actionParams;
    }

    public void setActionParams(String actionParams) {
        this.actionParams = actionParams;
    }

    public String getFilterCondition() {
        return filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getActionType() {
        return actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public String getValid() {
        return valid;
    }

    public void setValid(String valid) {
        this.valid = valid;
    }

    public String getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(String tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDbName() {
        return dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getConversionFilterCondition() {
        return conversionFilterCondition;
    }

    public void setConversionFilterCondition(String conversionFilterCondition) {
        this.conversionFilterCondition = conversionFilterCondition;
    }
}
