package com.digiwin.athena.cdme.repository.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;

import java.time.LocalDateTime;

/**
 * @description: 侦测触发定时配置属性
 * @author: renwm
 * @date: 2020/4/28 11:14
 */
@TableName("sd_monitor_trigger_ins")
public class MonitorTriggerInsModel {
    /** 主键ID */
    @TableId(type = IdType.AUTO)
    private String id;
    /** 关联表主键,排程表触发实例ID */
    private String triggerId;
    /** eoc公司ID */
    private String eocCompanyId;
    /** eoc工厂ID */
    private String eocSiteId;
    /** 创建时间 */
    private LocalDateTime createTime;
    /** 更新时间 */
    private LocalDateTime updateTime;
    /** 侦测触发时间 */
    private LocalDateTime lastMonitorTime;

    public MonitorTriggerInsModel() {
    }

    public MonitorTriggerInsModel(String triggerId, String eocCompanyId, String eocSiteId) {
        this.triggerId = triggerId;
        this.eocCompanyId = eocCompanyId;
        this.eocSiteId = eocSiteId;
        LocalDateTime currentDateTime = LocalTimeUtil.now();
        this.createTime = currentDateTime;
        this.updateTime = currentDateTime;
    }

    public MonitorTriggerInsModel(String triggerId, String eocCompanyId, String eocSiteId, LocalDateTime lastMonitorTime) {
        this.triggerId = triggerId;
        this.eocCompanyId = eocCompanyId;
        this.eocSiteId = eocSiteId;
        LocalDateTime currentDateTime = LocalTimeUtil.now();
        this.createTime = currentDateTime;
        this.updateTime = currentDateTime;
        this.lastMonitorTime = lastMonitorTime;
    }

    public String getTriggerId() {
        return triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public LocalDateTime getLastMonitorTime() {
        return lastMonitorTime;
    }

    public void setLastMonitorTime(LocalDateTime lastMonitorTime) {
        this.lastMonitorTime = lastMonitorTime;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}

    