package com.digiwin.athena.cdme.repository.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.JsonUtil;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * @description: 侦测触发定时配置属性
 * @author: renwm
 * @date: 2020/4/28 11:14
 */
@TableName("sd_monitor_trigger")
public class MonitorTriggerModel {
    /** 主键ID */
    private String id;
    @TableId(type = IdType.AUTO)
    private Long kid;
    /** 规则ID */
    private String ruleId;
    /** 租户ID */
    private String tenantId;
    /** 轮询周期json字符串 */
    private String triggerParam;
    /** 类型,1.标准 2:特殊 */
    private Integer triggerType;
    /** 创建时间 */
    private LocalDateTime createTime;
    /** 更新时间 */
    private LocalDateTime updateTime;
    /** 侦测触发时间 */
    private LocalDateTime lastMonitorTime;

    public MonitorTriggerModel(){
    }

    public MonitorTriggerModel(String ruleId, String tenantId, String triggerParam) {
        this.id = UUID.randomUUID().toString();
        this.ruleId = ruleId;
        this.tenantId = tenantId;
        this.triggerType = 1;
        this.triggerParam = triggerParam;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getKid() {
        return kid;
    }

    public void setKid(Long kid) {
        this.kid = kid;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTriggerParam() {
        return triggerParam;
    }

    public void setTriggerParam(String triggerParam) {
        this.triggerParam = triggerParam;
    }

    public Integer getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public LocalDateTime getLastMonitorTime() {
        return lastMonitorTime;
    }

    public void setLastMonitorTime(LocalDateTime lastMonitorTime) {
        this.lastMonitorTime = lastMonitorTime;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}

    