package com.digiwin.athena.cdme.service.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @description: 侦测对外接口
 * @author: dongwh
 * @date: 2021/4/12 11:03
 */
@Component("cdmeCustomHttpClient")
class CustomHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);

    private final RestTemplate restTemplate;

    public CustomHttpClient(@Qualifier("cdmeRestTemplate") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <T> T execute(String url, Object bodyParam, HttpHeaders headers, Class<T> cls, HttpMethod httpMethod, Object... uriVariables) {
        /** 设置header信息 */
        headers.setContentType(MediaType.APPLICATION_JSON);
        LOGGER.debug("调用doPost中的headers:[{}]", headers);
        HttpEntity<?> httpEntity = new HttpEntity<>(bodyParam, headers);
        ResponseEntity<T> responseEntity = restTemplate.exchange(url, httpMethod, httpEntity, cls, uriVariables);
        return responseEntity.getBody();
    }


}
