package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.ITaskEngineClient;
import com.digiwin.athena.cdme.service.client.request.CreateProjectReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/1/12 14:03
 */
@Service("cdmeTaskEngineClientImpl")
public class TaskEngineClientImpl extends AbstractExecuteClient implements ITaskEngineClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskEngineClientImpl.class);

    @Override
    public ResultDto<JSON> createProject(String projectCode, EocDto eocDto, JSONArray monitorData) {
        String locale = (String) DWServiceContext.getContext().getRequestHeader().get(FieldConstant.LOCALE);
        CreateProjectReq req = new CreateProjectReq(projectCode, locale, eocDto.toUnderLineMap(), monitorData);
        LOGGER.info("侦测调用任务引擎请求入参:[{}]", JsonUtil.getJsonString(req));
        /** 调用任务引擎 */
        String respContent = post(ConfigConstant.CREATE_PROJECT_URL, req, DWServiceContext.getContext().getToken(), String.class);
        /** NOTE 调用任务引擎返回不为空且status=200就认为是正常的返回数据 */
        LOGGER.info("侦测调用任务引擎返回结果:[{}]", respContent);
        JSON respJsonObject = ServiceResponseUtil.parseExecutionRespData(respContent);
        if (respJsonObject == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.TASK_400);
        }
        return ResultHelper.generateSuccessResult(respJsonObject);
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.TASK_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR :
                return ErrorCodeEnum.TASK_500;
            case BAD_GATEWAY :
                return ErrorCodeEnum.TASK_502;
            case SERVICE_UNAVAILABLE :
                return ErrorCodeEnum.TASK_503;
            case GATEWAY_TIMEOUT :
                return ErrorCodeEnum.TASK_504;
        }
        return ErrorCodeEnum.TASK_OTHER_ERR;
    }
}
