package com.digiwin.athena.cdme.service.client.request;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: esp sdk调用入参
 * @author: renwm
 * @date: 2020/6/17 10:22
 */
public class EspSdkReq<T extends BaseEspParameter> {

    private String hostVer = "1.0";

    private String hostAcct = "athena";

    private String tenantId;

    private String serviceProd;

    private String serviceName;

    private Map<String, String> datakey;

    private String bodyJsonString;

    private EocDto eocDto;

    public EspSdkReq(MonitorRuleModel ruleModel, EocDto eocDto, T parameter, String serviceName) {
        this(ruleModel.getTenantId(), eocDto, ruleModel.getProductName(), parameter, ruleModel.getRuleId(), serviceName);
    }

    public EspSdkReq(String tenantId, EocDto eocDto, String productName, T parameter, String ruleId, String serviceName) {
        this.tenantId = tenantId;
        this.serviceProd = productName;
        Map<String, Object> bodyMap = new HashMap<>(1, 1);
        Map<String, Object> parameterMap = new HashMap<>(1, 1);
        parameterMap.put(FieldConstant.ESP_PARAMETER, parameter);
        bodyMap.put(FieldConstant.ESP_STD_DATA, parameterMap);
        this.bodyJsonString = JsonUtil.getJsonString(bodyMap);
        this.eocDto = eocDto;
        datakey = new HashMap<>(1);
        datakey.put(FieldConstant.RULEID, ruleId);
        this.serviceName = serviceName;
    }

    public String getHostVer() {
        return hostVer;
    }

    public void setHostVer(String hostVer) {
        this.hostVer = hostVer;
    }

    public String getHostAcct() {
        return hostAcct;
    }

    public void setHostAcct(String hostAcct) {
        this.hostAcct = hostAcct;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getServiceProd() {
        return serviceProd;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, String> getDatakey() {
        return datakey;
    }

    public void setDatakey(Map<String, String> datakey) {
        this.datakey = datakey;
    }

    public String getBodyJsonString() {
        return bodyJsonString;
    }

    public void setBodyJsonString(String bodyJsonString) {
        this.bodyJsonString = bodyJsonString;
    }

    public EocDto getEocDto() {
        return eocDto;
    }

    public void setEocDto(EocDto eocDto) {
        this.eocDto = eocDto;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }

}
