package com.digiwin.athena.cdme.service.client.request;

import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.pojo.BaseEntity;

import java.util.Arrays;
import java.util.List;

/**
 * @description: 获取过期应用对应的侦测规则调用入参
 * @author: dongwh
 * @date: 2022/7/29 10:37
 */
public class ExpireRuleReq extends BaseEntity {

    private String tenantId;

    private String appCode;

    /**
     * 续期处理类型：renew/expire/clean
     */
    private String eventType;

    /**
     * 调用kg的各个组件名称：项目 Project，任务Task，侦测 MonitorRule
     */
    private List<String> component;

    public ExpireRuleReq() {
    }

    public ExpireRuleReq(String tenantId, String appCode, String eventType) {
        this.tenantId = tenantId;
        this.appCode = appCode;
        this.eventType = eventType;
        this.component = Arrays.asList(FieldConstant.EXPIRE_COMPONENT);
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getEventType() {
        return eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public List<String> getComponent() {
        return component;
    }

    public void setComponent(List<String> component) {
        this.component = component;
    }
}
