package com.digiwin.athena.cdme.service.client.request;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.pojo.dto.EocDto;

import java.time.LocalDateTime;

/**
 * @description: 埋点入参
 * @author: liunansheng
 * @date: 2021/12/15 9:36
 */
public class MonitorSuccessResultLogReq extends BaseMonitorResultLogReq {

    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime detectTime;

    private Integer state;

    private Integer initial = 0;

    private JSONArray processEntities;

    public MonitorSuccessResultLogReq() {
    }

    public MonitorSuccessResultLogReq(LocalDateTime detectTime, Integer state, JSONArray processEntities, String tenantId, String ruleCode, EocDto eocId) {
        this.detectTime = detectTime;
        this.state = state;
        this.processEntities = processEntities;
        this.setTenantId(tenantId);
        this.setRuleCode(ruleCode);
        this.setEocId(eocId);
    }

    public LocalDateTime getDetectTime() {
        return detectTime;
    }

    public void setDetectTime(LocalDateTime detectTime) {
        this.detectTime = detectTime;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public JSONArray getProcessEntities() {
        return processEntities;
    }

    public void setProcessEntities(JSONArray processEntities) {
        this.processEntities = processEntities;
    }

    public Integer getInitial() {
        return initial;
    }

    public void setInitial(Integer initial) {
        this.initial = initial;
    }
}
