package com.digiwin.athena.cdme.service.client.request;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.cdme.pojo.BaseEntity;
import com.digiwin.athena.cdme.pojo.dto.EocDto;

import java.util.Map;

/**
 * @description: 发起服务编排参数
 * @author: liunansheng
 * @date: 2021/10/22 14:02
 */
public class ProcessServiceComposerReq extends BaseEntity {
    /**
     * 服务编排模板ID
     */
    private String serviceComposerId;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * eoc信息
     */
    private Map<String, Object> eocMap;

    private boolean asyncComplete;

    private JSONArray detectedData;

    public ProcessServiceComposerReq(String serviceComposerId, String tenantId, EocDto eocMap, JSONArray detectedData) {
        this.serviceComposerId = serviceComposerId;
        this.tenantId = tenantId;
        this.eocMap = eocMap.toUnderLineMap();
        this.detectedData = detectedData;
    }

    public ProcessServiceComposerReq() {
    }

    public String getServiceComposerId() {
        return serviceComposerId;
    }

    public void setServiceComposerId(String serviceComposerId) {
        this.serviceComposerId = serviceComposerId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, Object> getEocMap() {
        return eocMap;
    }

    public void setEocMap(Map<String, Object> eocMap) {
        this.eocMap = eocMap;
    }

    public boolean isAsyncComplete() {
        return asyncComplete;
    }

    public void setAsyncComplete(boolean asyncComplete) {
        this.asyncComplete = asyncComplete;
    }

    public JSONArray getDetectedData() {
        return detectedData;
    }

    public void setDetectedData(JSONArray detectedData) {
        this.detectedData = detectedData;
    }
}
