package com.digiwin.athena.cdme.service.facade.detection.data;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.TriggerRepDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 15:26
 */
public interface IDupDataCacheFacadeService {

    /**
     * 缓存侦测数据，用于去重处理
     *
     * @param ruleModel
     * @param eocDto
     * @param changeData
     * @param redisKey
     * @param dupData
     * @param isAppend
     * @throws InterruptedException
     */
    void syncProcess(MonitorRuleModel ruleModel, EocDto eocDto, JSONArray changeData,
        JSONArray dupData
        , String redisKey, boolean isAppend);

    /**
     * 清除规则去重数据
     * @param ruleModel
     * @param eocDto
     * @return
     */
    ResultDto<Void> cleanDeduplicateData(MonitorRuleModel ruleModel, EocDto eocDto);

    /**
     * 清除ins对应的去重数据
     * @param ruleModel
     * @param triggerRepDto
     * @return
     */
    ResultDto<Void> cleanDeduplicateData(MonitorRuleModel ruleModel, TriggerRepDto triggerRepDto);

    /**
     * 根据key删除缓存数据
     * @param cacheKey
     * @return
     */
    boolean deleteCacheByKey(String cacheKey);

    /**
     * 保存去重数据
     * @param ruleModel
     * @param eocDto
     * @param cacheKey
     * @param data
     * @return
     */
    ResultDto<Void> saveDupData(MonitorRuleModel ruleModel, EocDto eocDto, String cacheKey,
        JSONArray data);

    /**
     * 缓存去重数据到redis
     * @param cacheKey
     * @param data
     * @return
     */
    ResultDto<Void> cacheDupData(String cacheKey, JSONArray data);

    /**
     * 获取去重数据缓存
     * @param cacheKey
     * @return
     */
    JSONArray getDupData(String cacheKey);
}
