package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.ITaskEngineClient;
import com.digiwin.athena.cdme.service.client.impl.IamClient;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/1/11 17:40
 */
@Service("cdmeActionProxy")
public class ActionProxy {

    private final static String DATAPULLING_ACTION = "datapulling";
    private final static String TASK_ACTION = "task";
    private final static String SERVICECOMPOSER_ACTION = "serviceComposer";

    private final IExecutionClient executionClient;

    private final IScwokerClient scwokerClient;

    private final ITaskEngineClient taskEngineClient;

    private final IamClient iamClient;

    public ActionProxy(IExecutionClient executionClient, IScwokerClient scwokerClient, ITaskEngineClient taskEngineClient, IamClient iamClient) {
        this.executionClient = executionClient;
        this.scwokerClient = scwokerClient;
        this.taskEngineClient = taskEngineClient;
        this.iamClient = iamClient;
    }

    public ResultDto<JSON> doAction(MonitorRuleModel ruleModel, EocDto eocDto,
                                    JSONArray monitorData, Map<String, JSONObject> allParams) {
        if (SERVICECOMPOSER_ACTION.equalsIgnoreCase(ruleModel.getActionType())) {
            initLocale();
            return scwokerClient.processService(ruleModel.getActionId(), ruleModel.getTenantId(), eocDto, monitorData);
        } else if (TASK_ACTION.equalsIgnoreCase(ruleModel.getActionType())) {
            initLocale();
            return taskEngineClient.createProject(ruleModel.getActionId(), eocDto, monitorData);
        } else {
            Map<String, Object> param = MonitorHelper.buildExecutionParam(ruleModel, eocDto, monitorData, allParams, FieldValConstant.EXECUTE_TYPE_ACTION);
            boolean needSignSource = !FieldValConstant.CATEGORY_REPORT.equalsIgnoreCase(ruleModel.getCategory());
            return executionClient.callExecution(param, needSignSource);
        }
    }

    private void initLocale() {
        String locale = (String) DWServiceContext.getContext().getRequestHeader().get(FieldConstant.LOCALE);
        if (StringUtil.isBlank(locale)) {
            locale = iamClient.getDefaultLocale();
            DWServiceContext.getContext().getRequestHeader().put(FieldConstant.LOCALE, locale);
        }
    }
}
