package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.execution.IProcessExecutionService;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/4 14:20
 */
@Service("cdmeProcessExecutionService")
public class ProcessExecutionService implements IProcessExecutionService {

    private static Logger LOGGER = LoggerFactory.getLogger(ProcessExecutionService.class);

    private final ActionProxy actionProxy;

    public ProcessExecutionService(ActionProxy actionProxy) {
        this.actionProxy = actionProxy;
    }

    @Override
    public ProcessPageDto processExecutionByPage(ExecuteRequestDto executeRequest, Map<String, JSONObject> allParam) {
        JSONArray changeObjects = executeRequest.getData();
        MonitorRuleModel ruleModel = executeRequest.getRuleModel();
        EocDto eoc = executeRequest.getEocDto();
        /** 根据分页数据量循环调用执行引擎 */
        List<JSONArray> pageChangeObjects;
        if (CollectionUtil.isEmpty(changeObjects) || changeObjects.size() < ruleModel.getPageSize()) {
            pageChangeObjects = Collections.singletonList(changeObjects);
        } else {
            pageChangeObjects = Lists.partition(changeObjects.toJavaList(JSONObject.class), ruleModel.getPageSize()).stream()
                    .map(changes -> JsonUtil.listToJsonArray(changes)).collect(Collectors.toList());
        }

        ProcessPageDto result = new ProcessPageDto(pageChangeObjects.size(), ruleModel.getPageSize());
        pageChangeObjects.stream().forEach(param -> {
            /**  调用执行引擎的侦测数据 */
            try {
                ResultDto<JSON> executionResult = actionProxy.doAction(ruleModel, eoc, param, allParam);
                if (MonitorHelper.isResultFail(executionResult)) {
                    result.addErrorResponse(executionResult);
                    LOGGER.error("分页发起行动失败，数据数为：{}", param);
                } else {
                    result.addSuccessResponse(executionResult.getData());
                    result.addSuccessChangeObjects(param);
                }
            } catch (Exception e) {
                LOGGER.error("分页发起行动返回异常，数据数为：[" + param + "]", e);
                /** 发起行动失败的数据 */
                DWRuntimeException runtimeException = e instanceof DWRuntimeException ? (DWRuntimeException) e
                        : new DWRuntimeException(ErrorCodeEnum.UNKNOW_ERR.getCode(), ErrorCodeEnum.UNKNOW_ERR.getMessage(), e);
                result.addErrorResponse(ResultHelper.generateFailResult(runtimeException.getErrorCode(), null));
            }
        });
        return result;
    }
}
