package com.digiwin.athena.cdme.service.facade.eoc;

import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.TriggerRepDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;

import java.util.List;

/**
 * eoc相关内容匹配处理
 *
 * @author zhangww
 * @date 2021/8/3 14:19
 */
public interface IMatchFacadeService {

    /**
     * 根据传入的参数，对比esp返回的运营单元与设置的运营单元，选择合适的运营单元集合返回
     *
     * @param ruleModel
     * @return
     */
    List<EocDto> match(MonitorRuleModel ruleModel);

    /**
     * 跨层级入参运营单元（newEocList）与triggerIns表中运营单元的匹配关系
     *
     * @param newEocDtos
     * @param insModels
     * @param ruleModel
     * @return
     */
    List<TriggerRepDto> processEocMatchIns(List<EocDto> newEocDtos,
        List<MonitorTriggerInsModel> insModels, MonitorRuleModel ruleModel);
}
