package com.digiwin.athena.cdme.service.facade.rulesync;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;

/**
 * @author zhangzhi@digiwin.com
 * @date 2020/9/28
 */
public interface ISyncFacadeService {
    /**
     * 同步规则信息
     *
     * @param ruleDto
     * @return
     */
    ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto);

    default ResultDto<Void> validRuleExists(MonitorCdcRuleDto ruleDto) {
        if (ruleDto.getRuleModel() == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_NOT_EXISTS);
        }
        return ResultHelper.generateSuccessResult(null);
    }
}
