package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.facade.detection.data.IDupDataCacheFacadeService;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 删除侦测规则
 * @author: dongwh
 * @date: 2021/10/20 14:27
 */
@Service(FieldValConstant.MONITOR_RULE_DELETED)
public class DeleteService implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteService.class);

    private final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;

    private final IMonitorRuleCdcService monitorRuleCdcService;

    public DeleteService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService,
                         IMonitorRuleCdcService monitorRuleCdcService) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.monitorRuleCdcService = monitorRuleCdcService;
    }

    @Override
    @Transactional(value = "cdmeTransactionManager")
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("删除CDC侦测规则入参: {}", ruleDto);
        if(StringUtils.isEmpty(ruleDto.getRuleId()) || StringUtils.isEmpty(ruleDto.getTenantId())){
            LOGGER.error("删除CDC侦测规则的侦测代号或者租户ID为空");
            return ResultHelper.generateResult(true, "");
        }

        MonitorCdcRuleDto monitorCdcRuleDto = new MonitorCdcRuleDto();
        MonitorRuleCdcModel ruleModel = monitorRuleCdcService.queryCdcRuleDetailByRuleIdAndTenantId(ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getEocMap());
        monitorCdcRuleDto.setRuleModel(ruleModel);

        ResultDto validResult = validRuleExists(monitorCdcRuleDto);
        if (MonitorHelper.isResultFail(validResult)) {
            return validResult;
        }

        /**删除规则*/
        ruleTriggerOperatorFacadeService.deleteCdcRule(monitorCdcRuleDto, ruleDto.getEocMap());
        LOGGER.info("删除CDC侦测规则成功");
        return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
    }
}