package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExpireRuleDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.client.request.ExpireRuleReq;
import com.digiwin.athena.cdme.service.client.response.ExpireRuleRes;
import com.digiwin.athena.cdme.service.facade.rulesync.IExpireRuleFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.RuleSyncFacadeProxy;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description  删除过期应用对应的侦测
 * @date 2023/11/10 10:15
 * @Copyright 鼎捷软件股份有限公司
 */
@Service("cdmeExpireRuleFacadeService")
public class ExpireRuleFacadeService implements IExpireRuleFacadeService {

    private final RuleSyncFacadeProxy ruleSyncFacadeProxy;
    private final IThemeMapClient themeMapClient;
    private final IMonitorRuleCdcService monitorRuleCdcService;

    public ExpireRuleFacadeService(RuleSyncFacadeProxy ruleSyncFacadeProxy, IThemeMapClient themeMapClient, IMonitorRuleCdcService monitorRuleCdcService) {
        this.ruleSyncFacadeProxy = ruleSyncFacadeProxy;
        this.themeMapClient = themeMapClient;
        this.monitorRuleCdcService = monitorRuleCdcService;
    }

    @Override
    public void processedExpireRule(ExpireRuleDto ruleExpireDto) {
        // 查询出过期应用所属的侦测规则
        ExpireRuleRes expireRules = getExpireRules(ruleExpireDto);
        if (CollectionUtil.isEmpty(expireRules.getRuleIds())) {
            return;
        }
        List<MonitorRuleCdcModel> monitorRules = new ArrayList<>();
        expireRules.getRuleIds().forEach(ruleId ->
                {
                    List<MonitorRuleCdcModel> monitorRuleCdcModels = monitorRuleCdcService.listByRuleIdAndTenantId(ruleId, expireRules.getTenantId());
                    if (CollectionUtil.isNotEmpty(monitorRuleCdcModels)) {
                        monitorRules.addAll(monitorRuleCdcModels);
                    }
                }
        );
        if (CollectionUtil.isEmpty(monitorRules)) {
            return;
        }
        // 删除过期应用规则
        monitorRules.forEach(monitorRule -> {
            EocDto eocDto = new EocDto(monitorRule.getEocCompanyId(), monitorRule.getEocSiteId(), null);
            SyncRuleParamDto syncRuleParamDto = new SyncRuleParamDto(expireRules.getTenantId(), monitorRule.getRuleId(), FieldValConstant.MONITOR_RULE_DELETED, eocDto, "", "");
            ruleSyncFacadeProxy.syncMonitorRuleHandler(syncRuleParamDto);
        });
    }

    private ExpireRuleRes getExpireRules(ExpireRuleDto ruleExpireDto) {
        return themeMapClient.getExpireRule(new ExpireRuleReq(ruleExpireDto.getTenantId(), ruleExpireDto.getAppCode(), ruleExpireDto.getEventType()));
    }
}
