package com.digiwin.athena.cdme.service.srp.db;

import com.digiwin.athena.cdme.core.base.IRepositoryService;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;

import java.util.List;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/3/7 13:39
 */
public interface IMonitorRuleService extends IRepositoryService<MonitorRuleModel> {


    /**
     * 根据ruleId tenantId eocMap更新pageSize
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @param pageSize
     * @return
     */
    boolean editPageSizeByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto,
        Integer pageSize);

    /**
     * 根据 ruleId tenantId eocMap删除规则
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    boolean deleteByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto);

    /**
     * 根据ruleId tenantId查询对应的侦测规则
     *
     * @param ruleId
     * @param tenantId
     * @return
     */
    List<MonitorRuleModel> listByRuleIdAndTenantId(String ruleId, String tenantId);

    /**
     * 根据ruleId tenantId triggerId查询对应的侦测规则
     *
     * @param ruleId
     * @param tenantId
     * @param triggerId
     * @return
     */
    MonitorRuleModel getByRuleIdAndTenantIdAndTriggerId(String ruleId, String tenantId,
        String triggerId);

    /**
     * 根据ruleId tenantId triggerId eocMap查询对应的侦测规则
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    MonitorRuleModel getByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto);

    /**
     * 根据tenantId  eocMap查询对应的侦测规则，按照ruleId排序
     *
     * @param tenantId
     * @param eocDto
     * @return
     */
    List<MonitorRuleModel> listByTenantIdAndEoc(String tenantId, EocDto eocDto);

    /**
     * 根据ruleId tenantId  eocMap查询对应的侦测规则
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    List<MonitorRuleModel> listByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId,
        EocDto eocDto);

    /**
     * 根据ruleId tenantId triggerId eocMap查询侦测规则，或略isEnable
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    MonitorRuleModel getRuleByRuleIdAndTenantIdAndEocIgnoreIsEnable(String ruleId, String tenantId,
        EocDto eocDto);
}
