package com.digiwin.athena.cdme.service.srp.db;

import com.digiwin.athena.cdme.core.base.IRepositoryService;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/3/16 13:28
 */
public interface IMonitorTriggerInsService extends IRepositoryService<MonitorTriggerInsModel> {

    /**
     * 根据triggerId 查询ins
     * @param triggerId
     * @return
     */
    List<MonitorTriggerInsModel> listByTriggerId(String triggerId);

    /**
     * 根据triggerId 更新ins
     * @param triggerId
     * @param updateBean
     * @return
     */
    boolean editByTriggerId(String triggerId, MonitorTriggerInsModel updateBean);

    /**
     * 根据triggerId 删除ins
     * @param triggerId
     * @return
     */
    boolean deleteByTriggerId(String triggerId);

    /**
     * 根据triggerId和eoc查询ins
     * @param triggerId
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    MonitorTriggerInsModel getByTriggerIdAndCompanyIdAndSiteId(String triggerId,
        String eocCompanyId, String eocSiteId);

    /**
     * 更新或新增ins
     * @return
     */
    boolean saveOrEdit(MonitorTriggerInsModel ins);
}
