package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorRecordMapper;
import com.digiwin.athena.cdme.repository.model.MonitorRecordModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRecordService;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/3/16 13:43
 */
@Service("cdmeMonitorRecordService")
public class MonitorRecordService extends AbstractRepositorService<CdmeMonitorRecordMapper, MonitorRecordModel> implements IMonitorRecordService {
    public MonitorRecordService(CdmeMonitorRecordMapper mapper) {
        super(mapper);
    }

    @Override
    public MonitorRecordModel getLastByRule(String ruleId, String tenantId, String eocCompanyId, String eocSiteId) {

        return mapper.selectOne(Wrappers.<MonitorRecordModel>lambdaQuery().eq(MonitorRecordModel::getRuleId, ruleId)
                .eq(MonitorRecordModel::getTenantId, tenantId)
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorRecordModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorRecordModel::getEocSiteId, eocSiteId)
                .orderByDesc(MonitorRecordModel::getUpdateTime).last("limit 1"));
    }
}
