package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorTriggerInsMapper;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerInsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/3/16 13:40
 */
@Service("cdmeMonitorTriggerInsService")
public class MonitorTriggerInsService extends AbstractRepositorService<CdmeMonitorTriggerInsMapper,MonitorTriggerInsModel> implements IMonitorTriggerInsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTriggerInsService.class);

    public MonitorTriggerInsService(CdmeMonitorTriggerInsMapper mapper) {
        super(mapper);
    }

    @Override
    public List<MonitorTriggerInsModel> listByTriggerId(String triggerId) {
        return mapper.selectList(Wrappers.<MonitorTriggerInsModel>lambdaQuery().eq(MonitorTriggerInsModel::getTriggerId, triggerId));
    }

    @Override
    public boolean editByTriggerId(String triggerId, MonitorTriggerInsModel updateBean) {
        int result = mapper.update(updateBean, Wrappers.<MonitorTriggerInsModel>lambdaUpdate().eq(MonitorTriggerInsModel::getTriggerId, triggerId));
        if (result < 1) {
            LOGGER.error("ins更新失败，更新参数{},triggerId:{}", JsonUtil.getJsonString(updateBean), triggerId);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteByTriggerId(String triggerId) {
        int result =  mapper.delete(Wrappers.<MonitorTriggerInsModel>lambdaQuery().eq(MonitorTriggerInsModel::getTriggerId, triggerId));
        if (result < 1) {
            LOGGER.error("ins删除失败，triggerId:{}", triggerId);
            return false;
        }
        return true;
    }

    @Override
    public MonitorTriggerInsModel getByTriggerIdAndCompanyIdAndSiteId(String triggerId, String eocCompanyId, String eocSiteId) {
        return mapper.selectOne(Wrappers.<MonitorTriggerInsModel>lambdaQuery()
                .eq(MonitorTriggerInsModel::getTriggerId, triggerId)
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorTriggerInsModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorTriggerInsModel::getEocSiteId, eocSiteId));
    }

    @Override
    public boolean saveOrEdit(MonitorTriggerInsModel ins) {
        if (null == ins.getId()) {
            return save(ins);
        }
        return edit(ins);
    }
}
