package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorTriggerMapper;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/3/16 13:29
 */
@Service("cdmeMonitorTriggerService")
public class MonitorTriggerService extends AbstractRepositorService<CdmeMonitorTriggerMapper, MonitorTriggerModel> implements IMonitorTriggerService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTriggerService.class);

    public MonitorTriggerService(CdmeMonitorTriggerMapper mapper) {
        super(mapper);
    }

    @Override
    public MonitorTriggerModel getByTriggerId(String triggerId) {
        return mapper.selectOne(Wrappers.<MonitorTriggerModel>lambdaQuery().eq(MonitorTriggerModel::getId, triggerId));
    }

    @Override
    public boolean deleteByTriggerId(String triggerId) {
        int result = mapper.delete(Wrappers.<MonitorTriggerModel>lambdaQuery().eq(MonitorTriggerModel::getId, triggerId));
        if (result < 1) {
            LOGGER.error("trigger删除失败，triggerId:{}", triggerId);
            return false;
        }
        return true;
    }
}
