/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.handler;

import com.digiwin.athena.cdme.core.exception.Retryable;
import com.digiwin.athena.cdme.core.exception.UnRetryable;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="cdmeConsumerErrorHandler")
public class ConsumerErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerErrorHandler.class);

    @Bean(value={"cdmeConsumeExceptionHandle"})
    RabbitListenerErrorHandler rabbitListenerErrorHandler() {
        return (amqpMessage, message, exception) -> {
            String queueName = message.getHeaders().get((Object)"amqp_consumerQueue").toString();
            String queueMsg = new String(amqpMessage.getBody(), StandardCharsets.UTF_8);
            Channel channel = (Channel)message.getHeaders().get((Object)"amqp_channel");
            long deliveryTag = amqpMessage.getMessageProperties().getDeliveryTag();
            if (exception.getCause() instanceof IllegalArgumentException || exception.getCause() instanceof UnRetryable) {
                LOGGER.error("\u4fa6\u6d4b\u5f15\u64ce\u5904\u7406\u961f\u5217[{}]\u7684\u6d88\u606f\u5f02\u5e38\uff0c\u6d88\u606f\u4e3a\uff1a[{}]\uff0c\u8bf7\u67e5\u770b\uff01[{}]", new Object[]{queueName, queueMsg, exception});
                channel.basicAck(deliveryTag, true);
            } else if (exception.getCause() instanceof Retryable) {
                LOGGER.error("\u4fa6\u6d4b\u5f15\u64ce\u5904\u7406\u961f\u5217[{}]\u7684\u6d88\u606f\u5f02\u5e38\uff0c\u6d88\u606f\u4e3a\uff1a[{}]\uff0c\u8bf7\u67e5\u770b\uff01[{}]", new Object[]{queueName, queueMsg, exception});
                channel.basicReject(deliveryTag, amqpMessage.getMessageProperties().getRedelivered() == false);
            } else {
                LOGGER.error("\u4fa6\u6d4b\u5f15\u64ce\u5904\u7406\u961f\u5217[{}]\u7684\u6d88\u606f\u5f02\u5e38\uff0c\u6d88\u606f\u4e3a\uff1a[{}]\uff0c\u8bf7\u67e5\u770b\uff01", new Object[]{queueName, queueMsg, exception});
                channel.basicReject(deliveryTag, amqpMessage.getMessageProperties().getRedelivered() == false);
            }
            return null;
        };
    }
}

