/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.util;

import com.digiwin.athena.cdme.core.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowIdUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowIdUtil.class);

    public static long uniqueLong() {
        return SnowFlake.SNOW_FLAKE.nextId();
    }

    public static String uniqueString() {
        return String.valueOf(SnowFlake.SNOW_FLAKE.nextId());
    }

    public static String uniqueLongHex() {
        return String.format("%016x", SnowIdUtil.uniqueLong());
    }

    private static class SnowFlake {
        private static final SnowFlake SNOW_FLAKE = new SnowFlake();
        private static final long EPOCH;
        private static final ZoneId ZONE;
        private static final long SEQUENCE_BITS = 12L;
        private static final long WORKER_ID_BITS = 10L;
        private static final long SEQUENCE_MASK = 4095L;
        private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
        private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
        private static final long BACKUP_COUNT = 3L;
        private static final long WORKER_ID_MAX_VALUE = 256L;
        private static long workerId;
        private long sequence;
        private long lastTime;
        private static Map<Long, Long> workerIdLastTimeMap;
        private static final long MAX_BACKWARD_MS = 3L;

        private SnowFlake() {
        }

        public static void setWorkerId(long workerId) {
            if (workerId < 0L || workerId >= 256L) {
                throw new BusinessException("workId \u521d\u59cb\u5316\u53c2\u6570\u4fe1\u606f\u975e\u6cd5");
            }
            SnowFlake.workerId = workerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized long nextId() {
            long currentMillis = System.currentTimeMillis();
            if (this.lastTime > currentMillis) {
                if (this.lastTime - currentMillis < 3L) {
                    SnowFlake snowFlake = this;
                    synchronized (snowFlake) {
                        try {
                            this.wait(this.lastTime - currentMillis);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                this.tryGenerateKeyOnBackup(currentMillis);
            }
            if (this.lastTime == currentMillis) {
                ++this.sequence;
                if (0L == (this.sequence &= 0xFFFL)) {
                    currentMillis = this.waitUntilNextTime(currentMillis);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTime = currentMillis;
            workerIdLastTimeMap.put(workerId, this.lastTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}-{}-{}", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.lastTime)), workerId, this.sequence});
            }
            return currentMillis - EPOCH << 22 | workerId << 12 | this.sequence;
        }

        private long tryGenerateKeyOnBackup(long currentMillis) {
            LOGGER.info("try GenerateKey OnBackup, map:{}", workerIdLastTimeMap);
            for (Map.Entry<Long, Long> entry : workerIdLastTimeMap.entrySet()) {
                workerId = entry.getKey();
                Long tempLastTime = entry.getValue();
                long l = this.lastTime = tempLastTime == null ? 0L : tempLastTime;
                if (this.lastTime > currentMillis) continue;
                return this.lastTime;
            }
            throw new BusinessException("Clock is moving backwards, current time is " + currentMillis + " milliseconds, workerId map = " + workerIdLastTimeMap);
        }

        private long waitUntilNextTime(long lastTime) {
            long time = System.currentTimeMillis();
            while (time <= lastTime) {
                time = System.currentTimeMillis();
            }
            return time;
        }

        static {
            ZONE = ZoneId.systemDefault();
            workerId = 1L;
            LocalDateTime begin = LocalDateTime.of(2021, 8, 30, 0, 0, 0);
            Instant instant = begin.atZone(ZONE).toInstant();
            EPOCH = instant.toEpochMilli();
            workerIdLastTimeMap = new ConcurrentHashMap<Long, Long>();
            int i = 0;
            while ((long)i <= 3L) {
                workerIdLastTimeMap.put(workerId + (long)i * 256L, 0L);
                ++i;
            }
        }
    }
}

