/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.mq.consumer.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.TraceId;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.FilterUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="cdmeMonitorExecuteCdcListener")
public class MonitorExecuteCdcListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorExecuteCdcListener.class);
    private final IMonitorRuleCdcService ruleCdcService;
    private final IMonitorFacadeService monitorFacadeService;
    private final ICacheService redisService;
    private final IContextFacadeService contextService;

    public MonitorExecuteCdcListener(IMonitorRuleCdcService ruleCdcService, IMonitorFacadeService monitorFacadeService, ICacheService redisService, IContextFacadeService contextService) {
        this.ruleCdcService = ruleCdcService;
        this.monitorFacadeService = monitorFacadeService;
        this.redisService = redisService;
        this.contextService = contextService;
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="queue_cdc", durable="true"), exchange=@Exchange(value="exchange_cdc", ignoreDeclarationExceptions="true"), key={"routingKey.cdc.executeMonitor"})}, errorHandler="cdmeConsumeExceptionHandle")
    @TraceId
    public void consumeMonitorMsg(Message message, Channel channel) throws Exception {
        String queueMsg = new String(message.getBody(), StandardCharsets.UTF_8);
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u63a5\u6536CDC\u7684\u5904\u7406\u6d88\u606f\u4e3a:[{}]", (Object)queueMsg);
        JSONObject data = JsonUtil.getObject(queueMsg);
        JSONObject after = ObjectUtils.isEmpty((Object)data.getJSONObject("after")) ? data.getJSONObject("before") : data.getJSONObject("after");
        String tenantId = StringUtils.isEmpty((CharSequence)data.getString("tenantId")) ? after.getString("tenant_id") : data.getString("tenantId");
        String tenantSid = after.getString("tenantsid");
        String tableName = data.getJSONObject("source").getString("table");
        String db = data.getJSONObject("source").getString("db");
        String op = data.getString("op");
        String changeType = MonitorHelper.getChangeType(op);
        String ruleId = after.getString("ruleId");
        List<MonitorRuleCdcModel> monitorRuleCdcModelList = new ArrayList<MonitorRuleCdcModel>();
        if (StringUtil.isEmpty(tenantId)) {
            monitorRuleCdcModelList = this.ruleCdcService.getByTenantSidAndTableAndChangeType(tenantSid, tableName, changeType);
            if (CollectionUtils.isEmpty(monitorRuleCdcModelList)) {
                LOGGER.error("\u8fc7\u6ee4\u539f\u56e0\uff0c\u6ca1\u6709\u914d\u7f6e\u8be5CDC\u4fa6\u6d4b\u89c4\u5219\uff0ctenantSid={}, tableName={}, changeType={}", new Object[]{tenantSid, tableName, changeType});
                throw new BusinessException("\u6ca1\u6709\u5339\u914d\u7684CDC\u4fa6\u6d4b\u4fe1\u606f\uff01");
            }
            tenantId = monitorRuleCdcModelList.get(0).getTenantId();
        }
        monitorRuleCdcModelList.clear();
        this.ruleCdcService.queryCdcRuleByTenantIdAndTableAndOp(monitorRuleCdcModelList, tenantId, db, tableName, changeType);
        if (CollectionUtils.isEmpty(monitorRuleCdcModelList)) {
            LOGGER.error("\u8fc7\u6ee4\u539f\u56e0\uff0c\u6ca1\u6709\u914d\u7f6e\u8be5CDC\u4fa6\u6d4b\u89c4\u5219\uff0c\u7f13\u5b58\u548c\u6570\u636e\u5e93\u90fd\u67e5\u4e0d\u5230\uff0ctenantId={}, tableName={}, changeType={}", new Object[]{tenantId, tableName, changeType});
            throw new BusinessException("\u6ca1\u6709\u5339\u914d\u7684CDC\u4fa6\u6d4b\u4fe1\u606f\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            monitorRuleCdcModelList = monitorRuleCdcModelList.stream().filter(res -> StringUtils.equals((CharSequence)res.getRuleId(), (CharSequence)ruleId)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(monitorRuleCdcModelList)) {
            LOGGER.error("\u8fc7\u6ee4\u539f\u56e0\uff0c\u6ca1\u6709\u914d\u7f6e\u8be5CDC\u4fa6\u6d4b\u89c4\u5219\uff0c\u7f13\u5b58\u548c\u6570\u636e\u5e93\u90fd\u67e5\u4e0d\u5230\uff0ctenantId={}, tableName={}, changeType={}", new Object[]{tenantId, tableName, changeType});
            throw new BusinessException("\u6ca1\u6709\u5339\u914d\u7684CDC\u4fa6\u6d4b\u4fe1\u606f\uff01");
        }
        Integer size = monitorRuleCdcModelList.size();
        while (size - 1 >= 0) {
            if (FilterUtil.filterData(data, op, monitorRuleCdcModelList.get(size - 1))) {
                monitorRuleCdcModelList.remove(size - 1);
            }
            Integer n = size;
            Integer n2 = size = Integer.valueOf(size - 1);
        }
        if (CollectionUtils.isEmpty(monitorRuleCdcModelList)) {
            LOGGER.error("\u901a\u8fc7\u89c4\u5219\u914d\u7f6e\u7684\u8fc7\u6ee4\u6761\u4ef6\u8fdb\u884c\u8fc7\u6ee4\u6ca1\u6709\u5339\u914d\u7684CDC\u4fa6\u6d4b\u4fe1\u606f\uff0ctenantId={}, tableName={}, changeType={}", new Object[]{tenantId, tableName, changeType});
            throw new BusinessException("\u901a\u8fc7\u89c4\u5219\u914d\u7f6e\u7684\u8fc7\u6ee4\u6761\u4ef6\u8fdb\u884c\u8fc7\u6ee4\u6ca1\u6709\u5339\u914d\u7684CDC\u4fa6\u6d4b\u4fe1\u606f\uff01");
        }
        LOGGER.info("\u8fc7\u6ee4\u540e\u7684\u89c4\u5219\u662f\uff0ctenantId={}, tableName={}, changeType={}\uff0crule={}", new Object[]{tenantId, tableName, changeType, JSON.toJSONString(monitorRuleCdcModelList)});
        monitorRuleCdcModelList.forEach(rule -> {
            EocDto eocDto = new EocDto(rule.getEocCompanyId(), rule.getEocSiteId(), null);
            JSONArray monitorData = new JSONArray();
            if ("MQTT".equals(rule.getCategory())) {
                monitorData.add((Object)after);
                monitorData.getJSONObject(0).remove((Object)"tenant_id");
                monitorData.getJSONObject(0).remove((Object)"ruleId");
            } else {
                monitorData.add((Object)this.getData(after, (MonitorRuleCdcModel)rule));
            }
            try {
                this.contextService.constructContext(rule.getTenantId());
            }
            catch (Exception e) {
                LOGGER.error("\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u5931\u8d25:{}", (Throwable)e);
                throw new BusinessException("\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u5931\u8d25", e);
            }
            this.monitorFacadeService.executeCdc((MonitorRuleCdcModel)rule, eocDto, monitorData);
        });
        channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
    }

    private JSONObject getData(JSONObject after, MonitorRuleCdcModel monitorRuleCdcModel) {
        JSONArray actionParams = JsonUtil.parseArray(monitorRuleCdcModel.getActionParams());
        JSONObject afterData = new JSONObject();
        for (Object object : actionParams) {
            JSONObject param = (JSONObject)object;
            afterData.put(param.getString("value"), after.get((Object)param.getString("name")));
        }
        return afterData;
    }
}

