/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.repository.model;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.pojo.dto.CrossLevelDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExpireRuleDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import java.time.LocalDateTime;

@TableName(value="sd_monitor_cdc_opt_record")
public class MonitorOptRecordModel {
    @TableId(type=IdType.AUTO)
    private String id;
    private String tenantId;
    private String ruleId;
    private String eocCompanyId;
    private String eocSiteId;
    private String eocRegionId;
    private String operateType;
    private String operateMode;
    private String operate;
    private String requestParam;
    private Integer status;
    private LocalDateTime createTime;

    public MonitorOptRecordModel() {
        this.createTime = LocalTimeUtil.now();
    }

    public MonitorOptRecordModel(String tenantId, String ruleId, String operate, EocDto eocDto, String requestParam) {
        this.tenantId = tenantId;
        this.ruleId = ruleId;
        if (eocDto != null) {
            this.eocCompanyId = eocDto.getEocCompanyId();
            this.eocSiteId = eocDto.getEocSiteId();
            this.eocRegionId = eocDto.getEocRegionId();
        }
        this.createTime = LocalTimeUtil.now();
        this.operate = operate;
        this.operateMode = "API";
        this.operateType = "SYNC";
        this.requestParam = requestParam;
        this.status = 0;
    }

    public MonitorOptRecordModel(SyncRuleParamDto ruleDto) {
        this.tenantId = ruleDto.getTenantId();
        this.ruleId = ruleDto.getRuleId();
        EocDto eocDto = ruleDto.getEocMap();
        if (eocDto != null) {
            this.eocCompanyId = eocDto.getEocCompanyId();
            this.eocSiteId = eocDto.getEocSiteId();
            this.eocRegionId = eocDto.getEocRegionId();
        }
        this.createTime = LocalTimeUtil.now();
        this.operate = ruleDto.getChangeType();
        this.operateMode = "MQ";
        this.operateType = "SYNC";
        this.requestParam = ruleDto.toString();
        this.status = 0;
    }

    public MonitorOptRecordModel(String tenantId, String ruleId, String backtrackDate, EocDto eocDto, boolean isSuccess) {
        this.tenantId = tenantId;
        this.ruleId = ruleId;
        if (eocDto != null) {
            this.eocCompanyId = eocDto.getEocCompanyId();
            this.eocSiteId = eocDto.getEocSiteId();
            this.eocRegionId = eocDto.getEocRegionId();
        }
        this.createTime = LocalTimeUtil.now();
        this.operate = "TRACK_BACK_TIME";
        this.operateMode = "API";
        this.operateType = "SET";
        JSONObject requestParam = new JSONObject();
        requestParam.put("tenantId", (Object)tenantId);
        requestParam.put("ruleId", (Object)ruleId);
        requestParam.put("eocMap", (Object)eocDto);
        requestParam.put("backtrackDate", (Object)backtrackDate);
        this.requestParam = requestParam.toJSONString();
        this.status = isSuccess ? 1 : 0;
    }

    public MonitorOptRecordModel(String tenantId, String ruleId, int pageSize, EocDto eocDto, boolean isSuccess) {
        this.tenantId = tenantId;
        this.ruleId = ruleId;
        if (eocDto != null) {
            this.eocCompanyId = eocDto.getEocCompanyId();
            this.eocSiteId = eocDto.getEocSiteId();
            this.eocRegionId = eocDto.getEocRegionId();
        }
        this.createTime = LocalTimeUtil.now();
        this.operate = "PAGE_SIZE";
        this.operateMode = "API";
        this.operateType = "SET";
        JSONObject requestParam = new JSONObject();
        requestParam.put("tenantId", (Object)tenantId);
        requestParam.put("ruleId", (Object)ruleId);
        requestParam.put("eocMap", (Object)eocDto);
        requestParam.put("pageSize", (Object)pageSize);
        this.requestParam = requestParam.toJSONString();
        this.status = isSuccess ? 1 : 0;
    }

    public MonitorOptRecordModel(CrossLevelDto crossLevelDto, Integer status) {
        this.tenantId = crossLevelDto.getTenantId();
        this.ruleId = crossLevelDto.getRuleId();
        if (crossLevelDto.getEocMap() != null) {
            this.eocCompanyId = crossLevelDto.getEocMap().getEocCompanyId();
            this.eocSiteId = crossLevelDto.getEocMap().getEocSiteId();
            this.eocRegionId = crossLevelDto.getEocMap().getEocRegionId();
        }
        this.createTime = LocalTimeUtil.now();
        this.operate = "CROSS_LEVEL";
        this.operateMode = "MQ";
        this.operateType = "SET";
        this.requestParam = crossLevelDto.toString();
        this.status = status;
    }

    public MonitorOptRecordModel(ExpireRuleDto ruleExpireDto, Integer status) {
        this.ruleId = "appExpire";
        this.tenantId = ruleExpireDto.getTenantId();
        this.createTime = LocalTimeUtil.now();
        this.operate = "RULE_EXPIRE";
        this.operateMode = "MQ";
        this.operateType = "SYNC";
        this.requestParam = ruleExpireDto.toString();
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getEocCompanyId() {
        return this.eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return this.eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getEocRegionId() {
        return this.eocRegionId;
    }

    public void setEocRegionId(String eocRegionId) {
        this.eocRegionId = eocRegionId;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getOperateMode() {
        return this.operateMode;
    }

    public void setOperateMode(String operateMode) {
        this.operateMode = operateMode;
    }

    public String getOperate() {
        return this.operate;
    }

    public void setOperate(String operate) {
        this.operate = operate;
    }

    public String getRequestParam() {
        return this.requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
}

