/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.exception.ResponseStatusException;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.service.client.CustomHttpClient;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public abstract class AbstractExecuteClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExecuteClient.class);
    @Autowired
    private CustomHttpClient httpClient;

    protected <T> T post(String url, Object serviceParam, String token, Class<T> cls) {
        return this.execute(url, serviceParam, token, cls, HttpMethod.POST, new Object[0]);
    }

    protected <T> T post(String url, Object serviceParam, String token, Class<T> cls, Consumer<HttpHeaders> headerAdder) {
        return this.execute(url, serviceParam, token, cls, HttpMethod.POST, headerAdder, new Object[0]);
    }

    protected <T> T execute(String url, Object serviceParam, String token, Class<T> cls, HttpMethod httpMethod, Object ... uriVariables) {
        return this.execute(url, serviceParam, token, cls, httpMethod, null, uriVariables);
    }

    protected <T> T execute(String url, Object serviceParam, String token, Class<T> cls, HttpMethod httpMethod, Consumer<HttpHeaders> headerAdder, Object ... uriVariables) {
        HttpHeaders headers = this.initHeader(token);
        if (this.isNeedAuthInfo()) {
            if (headers == null) {
                headers = new HttpHeaders();
            }
            this.setAuthInfo(headers);
        }
        if (headerAdder != null) {
            if (headers == null) {
                headers = new HttpHeaders();
            }
            headerAdder.accept(headers);
        }
        try {
            return this.httpClient.execute(url, serviceParam, headers, cls, httpMethod, uriVariables);
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{httpMethod, url, e.getResponseBodyAsString(), e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, e.getStatusCode()), (Throwable)e);
        }
        catch (HttpServerErrorException e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{httpMethod, url, e.getResponseBodyAsString(), e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, e.getStatusCode()), (Throwable)e);
        }
        catch (UnknownHttpStatusCodeException e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{httpMethod, url, e.getResponseBodyAsString(), e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, null), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{httpMethod, url, e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, null), (Throwable)e);
        }
    }

    protected <T> T postWithoutRouterkey(String url, Object serviceParam, String token, Class<T> cls, Consumer<HttpHeaders> headerAdder) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", token);
        headers.set("traceId", DWServiceContext.getContext().getTraceId());
        headerAdder.accept(headers);
        try {
            return this.httpClient.execute(url, serviceParam, headers, cls, HttpMethod.POST, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{HttpMethod.POST, url, e.getResponseBodyAsString(), e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, e.getStatusCode()), (Throwable)e);
        }
        catch (HttpServerErrorException e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{HttpMethod.POST, url, e.getResponseBodyAsString(), e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, e.getStatusCode()), (Throwable)e);
        }
        catch (UnknownHttpStatusCodeException e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{HttpMethod.POST, url, e.getResponseBodyAsString(), e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, null), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("{}\u8bf7\u6c42[{}]\u51fa\u73b0\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: {}", new Object[]{HttpMethod.POST, url, e});
            throw new ResponseStatusException(this.getErrorCodeByHttpStatus(url, null), (Throwable)e);
        }
    }

    protected HttpHeaders initHeader(String token) {
        String routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
        if (StringUtil.isEmpty(routerKey)) {
            throw new BusinessException(ErrorCodeEnum.ROUTE_KEY_EMPTY);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("routerKey", routerKey);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (StringUtil.isNotBlank(locale)) {
            headers.set("locale", locale);
        }
        headers.set("token", token);
        headers.set("traceId", DWServiceContext.getContext().getTraceId());
        return headers;
    }

    protected abstract ErrorCodeEnum getErrorCodeByHttpStatus(String var1, HttpStatus var2);

    protected boolean isNeedAuthInfo() {
        return false;
    }

    private void setAuthInfo(HttpHeaders headers) {
        headers.set("digi-middleware-auth-app", ConfigConstant.MULTIPLEAPPENV ? ConfigConstant.MERGED_IAM_APP_TOKEN : ConfigConstant.IAM_APP_TOKEN);
        headers.set("digi-middleware-auth-user", DWServiceContext.getContext().getToken());
    }
}

