/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.DWResponseUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.request.ExistActiveProjectReq;
import com.digiwin.athena.cdme.service.client.request.ProcessServiceComposerReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component(value="cdmeScWokerClient")
public class ScWokerClient
extends AbstractExecuteClient
implements IScwokerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScWokerClient.class);

    @Override
    public boolean existActiveProject(String serviceComposerId, String tenantId, EocDto eocMap) {
        ExistActiveProjectReq req = new ExistActiveProjectReq(serviceComposerId, tenantId, eocMap);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u670d\u52a1\u7f16\u6392\u67e5\u8be2\u662f\u5426\u6709\u8fdb\u884c\u4e2d\u9879\u76ee\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)req);
        JSONObject responseObj = this.post(ConfigConstant.SCWORKER_EXISTACTIVEPROJECT_URL, req, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u670d\u52a1\u7f16\u6392\u67e5\u8be2\u662f\u5426\u6709\u8fdb\u884c\u4e2d\u9879\u76ee\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)responseObj);
        ResultDto<Boolean> rs = DWResponseUtil.convertResponse(responseObj, Boolean.class);
        if (MonitorHelper.isResultFail(rs)) {
            throw new BusinessException(ErrorCodeEnum.SCWOKER_400);
        }
        return rs.getData();
    }

    @Override
    public ResultDto<JSON> processService(String serviceComposerId, String tenantId, EocDto eocDto, JSONArray monitorData) {
        ProcessServiceComposerReq req = new ProcessServiceComposerReq(serviceComposerId, tenantId, eocDto, monitorData);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u670d\u52a1\u7f16\u6392\u8bf7\u6c42\u5165\u53c2:[{}]", (Object)JsonUtil.getJsonString(req));
        String respContent = this.post(ConfigConstant.SCWORKER_PROCESS_SERVICE_URL, req, DWServiceContext.getContext().getToken(), String.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u670d\u52a1\u7f16\u6392\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)respContent);
        JSON respJsonObject = ServiceResponseUtil.parseExecutionRespData(respContent);
        if (respJsonObject == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.SCWOKER_400, new JSON[0]);
        }
        return ResultHelper.generateSuccessResult(respJsonObject);
    }

    @Override
    protected HttpHeaders initHeader(String token) {
        HttpHeaders headers = super.initHeader(token);
        headers.add("invokerId", "MonitorEngine");
        return headers;
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.SCWOKER_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.SCWOKER_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.SCWOKER_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.SCWOKER_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.SCWOKER_504;
            }
        }
        return ErrorCodeEnum.SCWOKER_OTHER_ERR;
    }
}

