/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.ITaskEngineClient;
import com.digiwin.athena.cdme.service.client.request.CreateProjectReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeTaskEngineClientImpl")
public class TaskEngineClientImpl
extends AbstractExecuteClient
implements ITaskEngineClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskEngineClientImpl.class);

    @Override
    public ResultDto<JSON> createProject(String projectCode, EocDto eocDto, JSONArray monitorData) {
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        CreateProjectReq req = new CreateProjectReq(projectCode, locale, eocDto.toUnderLineMap(), monitorData);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u8bf7\u6c42\u5165\u53c2:[{}]", (Object)JsonUtil.getJsonString(req));
        String respContent = this.post(ConfigConstant.CREATE_PROJECT_URL, req, DWServiceContext.getContext().getToken(), String.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u4efb\u52a1\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)respContent);
        JSON respJsonObject = ServiceResponseUtil.parseExecutionRespData(respContent);
        if (respJsonObject == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.TASK_400, new JSON[0]);
        }
        return ResultHelper.generateSuccessResult(respJsonObject);
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.TASK_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.TASK_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.TASK_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.TASK_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.TASK_504;
            }
        }
        return ErrorCodeEnum.TASK_OTHER_ERR;
    }
}

