/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.bo.DetectionRespBO;
import com.digiwin.athena.cdme.pojo.dto.DeduplicateDto;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.facade.detection.data.DetectionFacdeProxy;
import com.digiwin.athena.cdme.service.facade.detection.data.IDetectionFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.data.IFinishDetectionService;
import com.digiwin.athena.cdme.service.facade.detection.data.IPreDetectionService;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="cdmeDetectionFacadeService")
public class DetectionFacadeService
implements IDetectionFacadeService {
    private final IPreDetectionService preDetectionService;
    private final DetectionFacdeProxy detectionFacdeProxy;
    private final IFinishDetectionService finishDetectionService;

    public DetectionFacadeService(IPreDetectionService preDetectionService, DetectionFacdeProxy detectionFacdeProxy, IFinishDetectionService finishDetectionService) {
        this.preDetectionService = preDetectionService;
        this.detectionFacdeProxy = detectionFacdeProxy;
        this.finishDetectionService = finishDetectionService;
    }

    @Override
    public ResultDto<DetectionRespBO> detect(DetectionRequestDto requestDto) {
        ResultDto<Map<String, JSONObject>> preResult = this.preDetectionService.parseConfig(requestDto.getRuleModel(), requestDto.getTimeRange());
        if (MonitorHelper.isResultFail(preResult)) {
            return ResultHelper.generateFailResult(preResult.getCode(), preResult.getMessage(), new DetectionRespBO[0]);
        }
        ResultDto<JSONArray> detectRs = this.detectionFacdeProxy.processDetection(preResult.getData(), requestDto);
        if (MonitorHelper.isResultFail(detectRs)) {
            return ResultHelper.generateFailResult(detectRs.getCode(), detectRs.getMessage(), new DetectionRespBO[0]);
        }
        ResultDto<DeduplicateDto> finishRs = this.finishDetectionService.deduplicate(detectRs.getData(), requestDto.getEoc(), requestDto.getRuleModel());
        if (MonitorHelper.isResultFail(finishRs)) {
            return ResultHelper.generateFailResult(finishRs.getCode(), finishRs.getMessage(), new DetectionRespBO[0]);
        }
        DeduplicateDto deduplicateDto = finishRs.getData();
        DetectionRespBO respBO = new DetectionRespBO(deduplicateDto.getAfterDup(), deduplicateDto.getIntersection());
        return ResultHelper.generateSuccessResult(respBO);
    }
}

