/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.DeduplicateDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorDupModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IFinishDetectionService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorDupService;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeFinishDetectionService")
public class FinishDetectionService
implements IFinishDetectionService {
    private static Logger LOGGER = LoggerFactory.getLogger(FinishDetectionService.class);
    private final ICacheService cacheService;
    private final IMonitorDupService monitorDupService;

    public FinishDetectionService(ICacheService cacheService, IMonitorDupService monitorDupService) {
        this.cacheService = cacheService;
        this.monitorDupService = monitorDupService;
    }

    @Override
    public ResultDto<DeduplicateDto> deduplicate(JSONArray data, EocDto eoc, MonitorRuleModel ruleModel) {
        if (CollectionUtil.isEmpty((Collection)data) || !MonitorHelper.isPollingIds(ruleModel.getMonitorRule())) {
            return ResultHelper.generateSuccessResult(new DeduplicateDto(data, null));
        }
        LOGGER.info("..... redis\u53bb\u91cd\u4e4b\u524d\u6570\u636e\u4e3a:{}", (Object)data);
        String cacheKey = MonitorHelper.buildRedisKey(ruleModel, eoc);
        JSONArray intersection = new JSONArray();
        JSONArray cacheObject = this.getCacheObject(cacheKey, ruleModel, eoc);
        if (CollectionUtil.isNotEmpty((Collection)cacheObject)) {
            JSONArray finalCacheObject = cacheObject;
            intersection = data.stream().filter(arg_0 -> ((JSONArray)finalCacheObject).contains(arg_0)).collect(Collectors.toCollection(JSONArray::new));
            data.removeAll((Collection)cacheObject);
        }
        LOGGER.info("..... redis\u53bb\u91cd\u4e4b\u540e\u6570\u636e\u4e3a:{}", (Object)data);
        return ResultHelper.generateSuccessResult(new DeduplicateDto(data, intersection));
    }

    protected JSONArray getCacheObject(String cacheKey, MonitorRuleModel ruleModel, EocDto eocDto) {
        try {
            boolean hasKey = this.cacheService.hasKey(cacheKey);
            if (hasKey) {
                JSONArray cacheStr = (JSONArray)this.cacheService.get(cacheKey);
                LOGGER.info("..... redis\u4e2d\u7f13\u5b58\u6570\u636e\u4e3a:{},redisKey\u4e3a:{}", (Object)cacheStr, (Object)cacheKey);
                return cacheStr;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53bb\u91cd\u65f6\u83b7\u53d6redis\u6570\u636e\u5f02\u5e38, \u53c2\u6570\u4e3a:ruleModel:[{}] eocDto:[{}] redisKey[{}]", new Object[]{ruleModel, JsonUtil.getJsonString(eocDto), cacheKey});
            LOGGER.error("\u53bb\u91cd\u65f6\u83b7\u53d6redis\u6570\u636e\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        MonitorDupModel monitorDup = this.monitorDupService.getByRuleIdAndTenantIdAndProdAndEocmap(ruleModel.getRuleId(), ruleModel.getTenantId(), ruleModel.getProductName(), eocDto);
        if (monitorDup == null) {
            return new JSONArray();
        }
        return JsonUtil.parseArray(monitorDup.getCacheValue());
    }
}

