/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.TimeRangeDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.request.DataChangeGetParameter;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;
import com.digiwin.athena.cdme.service.facade.detection.data.IProcessDetectionService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeSCAN")
public class ScanDetectionService
implements IProcessDetectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanDetectionService.class);
    private final IEspClient espClient;

    public ScanDetectionService(IEspClient espClient) {
        this.espClient = espClient;
    }

    @Override
    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        EspSdkReq scanParam = this.buildParam(allParam, requestDto.getRuleModel(), requestDto.getTimeRange(), requestDto.getEoc());
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ESP\u5f00\u59cb*************");
        ResultDto<JSONArray> scanResult = this.espClient.getChangeObjects(scanParam);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ESP\u7ed3\u675f*************");
        return scanResult;
    }

    private EspSdkReq buildParam(Map<String, JSONObject> allParam, MonitorRuleModel ruleModel, TimeRangeDto timeRange, EocDto eocDto) {
        DataChangeGetParameter parameter = new DataChangeGetParameter();
        parameter.setEnterprise_no("");
        parameter.setSite_no("");
        parameter.setTenant_id(ruleModel.getTenantId());
        if ("cdmeSCAN".equals(ruleModel.getCategory()) && !"CUSTOM".equals(ruleModel.getMonitorType())) {
            parameter.setDatetime_s(LocalTimeUtil.getDateTimeMs(timeRange.getStartTime()));
            parameter.setDatetime_e(LocalTimeUtil.getDateTimeMs(timeRange.getEndTime()));
        }
        JSONObject ruleObj = JsonUtil.getObject(ruleModel.getMonitorRule());
        ruleObj.put("rule_id", (Object)ruleModel.getRuleId());
        ruleObj.put("category", (Object)ruleModel.getCategory());
        ruleObj.put("version", (Object)"-1");
        ruleObj = this.parseCondition(allParam, ruleObj);
        ruleObj.fluentRemove((Object)"dynamic_params").fluentRemove((Object)"static_params").fluentRemove((Object)"is_continue").fluentRemove((Object)"is_polling_ids").fluentRemove((Object)"is_deduplication").fluentRemove((Object)"bk_info").fluentRemove((Object)"chill_interval");
        parameter.setRules(Collections.singletonList(ruleObj));
        return new EspSdkReq<DataChangeGetParameter>(ruleModel, eocDto, parameter, "data.change.get");
    }

    protected JSONObject parseCondition(Map<String, JSONObject> allParam, JSONObject ruleObj) {
        JSONObject conditionObj = ruleObj.getJSONObject("dynamic_condition");
        if (CollectionUtil.isEmpty((Map)conditionObj)) {
            return ruleObj;
        }
        this.recursionItems(allParam, conditionObj);
        return ruleObj;
    }

    private void recursionItems(Map<String, JSONObject> allParam, JSONObject itemObj) {
        String type = itemObj.getString("type");
        if ("SINGLE".equals(type)) {
            this.handleItem(allParam, itemObj);
        } else {
            itemObj.getJSONArray("items").forEach(item -> this.recursionItems(allParam, (JSONObject)item));
        }
    }

    private void handleItem(Map<String, JSONObject> allParam, JSONObject itemObj) {
        if ("IN".equals(itemObj.getString("op")) || "NOT_IN".equals(itemObj.getString("op"))) {
            if ("PARAM".equals(itemObj.getString("right_value_type"))) {
                JSONArray paramKeys = itemObj.getJSONArray("right");
                itemObj.put("right_value_type", allParam.get(paramKeys.get(0)).get((Object)"type"));
                itemObj.put("right", (Object)JsonUtil.getJsonString(this.getRightValue(itemObj.getString("right_value_type"), allParam, paramKeys)));
            } else {
                itemObj.put("right", (Object)JsonUtil.getJsonString(itemObj.get((Object)"right")));
            }
        } else if ("PARAM".equals(itemObj.getString("right_value_type"))) {
            itemObj.put("right_value_type", allParam.get(itemObj.get((Object)"right")).get((Object)"type"));
            itemObj.put("right", allParam.get(itemObj.get((Object)"right")).get((Object)"value"));
        }
    }

    private List getRightValue(String rightValType, Map<String, JSONObject> allParam, JSONArray paramKeys) {
        if ("STRING".equals(rightValType)) {
            return paramKeys.stream().map(key -> ((JSONObject)allParam.get(key)).getString("value")).collect(Collectors.toList());
        }
        if ("INT".equals(rightValType)) {
            return paramKeys.stream().map(key -> ((JSONObject)allParam.get(key)).getInteger("value")).collect(Collectors.toList());
        }
        if ("BOOLEAN".equals(rightValType)) {
            return paramKeys.stream().map(key -> ((JSONObject)allParam.get(key)).getBoolean("value")).collect(Collectors.toList());
        }
        if ("DECIMAL".equals(rightValType)) {
            return paramKeys.stream().map(key -> ((JSONObject)allParam.get(key)).getBigDecimal("value")).collect(Collectors.toList());
        }
        throw new BusinessException(ErrorCodeEnum.DYNAMIC_RULE_ILLEGAL);
    }
}

