/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.bo.DetectionAndExecuteContextBO;
import com.digiwin.athena.cdme.pojo.bo.DetectionRespBO;
import com.digiwin.athena.cdme.pojo.dto.ActiveDetectionRuleDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.IActiveMonitorFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.IDetectionEventService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IExectionService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeActiveMonitorFacadeService")
public class ActiveMonitorFacadeService
implements IActiveMonitorFacadeService {
    private static Logger LOGGER = LoggerFactory.getLogger(ActiveMonitorFacadeService.class);
    private final IExectionService exectionService;
    private final IDetectionEventService detectionEventService;

    public ActiveMonitorFacadeService(IExectionService exectionService, IDetectionEventService detectionEventService) {
        this.exectionService = exectionService;
        this.detectionEventService = detectionEventService;
    }

    @Override
    public ResultDto execute(ActiveDetectionRuleDto detectionRuleDto) {
        ResultDto<ProcessPageDto> resultDto;
        MonitorRuleModel ruleModel = detectionRuleDto.getRuleModel();
        EocDto eoc = detectionRuleDto.getEoc();
        DetectionAndExecuteContextBO contextBO = new DetectionAndExecuteContextBO(eoc, LocalDateTime.now());
        DetectionRespBO detectionRes = new DetectionRespBO(detectionRuleDto.getData(), null);
        contextBO.setDetectionRs(ResultHelper.generateSuccessResult(detectionRes));
        this.detectionEventService.startDetection(ruleModel);
        try {
            ExecuteRequestDto executeRequestDto = new ExecuteRequestDto(ruleModel, eoc, detectionRuleDto.getData(), null);
            ResultDto<ProcessPageDto> executeRs = this.exectionService.execute(executeRequestDto);
            contextBO.setExecuteRs(executeRs);
            resultDto = executeRs;
        }
        catch (Exception e) {
            try {
                DWRuntimeException runtimeException = e instanceof DWRuntimeException ? (DWRuntimeException)((Object)e) : new DWRuntimeException(ErrorCodeEnum.UNKNOW_ERR.getCode(), ErrorCodeEnum.UNKNOW_ERR.getMessage(), (Throwable)e);
                throw runtimeException;
            }
            catch (Throwable throwable) {
                this.detectionEventService.endDetection("sys", ruleModel, Lists.newArrayList((Object[])new DetectionAndExecuteContextBO[]{contextBO}));
                throw throwable;
            }
        }
        this.detectionEventService.endDetection("sys", ruleModel, Lists.newArrayList((Object[])new DetectionAndExecuteContextBO[]{contextBO}));
        return resultDto;
    }
}

