/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.digiwin.athena.cdme.core.config.CdmeApplicationProp;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.bo.EocTimeRangeBO;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.facade.detection.IDetectionTimeRangeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerInsService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="cdmeDetectionTimeRangeService")
public class DetectionTimeRangeService
implements IDetectionTimeRangeService {
    private final IMonitorTriggerInsService insService;
    private final CdmeApplicationProp applicationProp;

    public DetectionTimeRangeService(IMonitorTriggerInsService insService, CdmeApplicationProp applicationProp) {
        this.insService = insService;
        this.applicationProp = applicationProp;
    }

    @Override
    public List<EocTimeRangeBO> getTimeRange(MonitorTriggerModel triggerModel, boolean needOffset, List<EocDto> eocList) {
        List<MonitorTriggerInsModel> insModels = this.insService.listByTriggerId(triggerModel.getId());
        ArrayList<EocTimeRangeBO> timeRangeBOS = new ArrayList<EocTimeRangeBO>();
        for (EocDto eoc : eocList) {
            LocalDateTime startTime;
            MonitorTriggerInsModel ins = this.findIns(eoc, insModels);
            if (null == ins) {
                ins = new MonitorTriggerInsModel(triggerModel.getId(), eoc.getEocCompanyId(), eoc.getEocSiteId());
            }
            LocalDateTime configStartTime = triggerModel.getLastMonitorTime();
            LocalDateTime lastMonitorTime = ins.getLastMonitorTime();
            if (null == lastMonitorTime && null == configStartTime) {
                startTime = triggerModel.getCreateTime();
            } else if (null == lastMonitorTime && null != configStartTime) {
                startTime = configStartTime;
            } else if (null != lastMonitorTime && null == configStartTime) {
                startTime = lastMonitorTime;
            } else {
                LocalDateTime localDateTime = startTime = lastMonitorTime.isAfter(configStartTime) ? lastMonitorTime : configStartTime;
            }
            if (needOffset && this.applicationProp.getMonitorOffsetTime() != null) {
                startTime = startTime.minus(this.applicationProp.getMonitorOffsetTime(), ChronoUnit.MILLIS);
            }
            EocTimeRangeBO timeRangeBO = new EocTimeRangeBO(eoc, startTime, LocalDateTime.now(), ins);
            timeRangeBOS.add(timeRangeBO);
        }
        return timeRangeBOS;
    }

    @Override
    public ResultDto<Void> moveTimeRange(EocTimeRangeBO timeRangeBO) {
        MonitorTriggerInsModel ins = timeRangeBO.getIns();
        ins.setLastMonitorTime(timeRangeBO.getEndTime());
        boolean success = this.insService.saveOrEdit(ins);
        if (success) {
            return ResultHelper.generateSuccessResult(null);
        }
        return ResultHelper.generateFailResult(ErrorCodeEnum.SAVE_INS_FAIL, new Void[0]);
    }

    private MonitorTriggerInsModel findIns(EocDto eoc, List<MonitorTriggerInsModel> insModels) {
        if (CollectionUtil.isEmpty(insModels)) {
            return null;
        }
        for (MonitorTriggerInsModel ins : insModels) {
            EocDto insEoc = new EocDto(ins.getEocCompanyId(), ins.getEocSiteId(), null);
            if (!eoc.equals(insEoc)) continue;
            return ins;
        }
        return null;
    }
}

