/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import com.digiwin.athena.cdme.service.client.IRouterClient;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.ITaskEngineClient;
import com.digiwin.athena.cdme.service.client.impl.IamClient;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="cdmeMonitorFacadeService")
public class MonitorFacadeService
implements IMonitorFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorFacadeService.class);
    private final IamClient iamClient;
    private final IExecutionClient executionClient;
    private final IScwokerClient scwokerClient;
    private final ITaskEngineClient taskEngineClient;
    private final ICacheService redisService;
    private final IRouterClient routerClient;
    private final IContextFacadeService contextService;

    public MonitorFacadeService(IamClient iamClient, IExecutionClient executionClient, IScwokerClient scwokerClient, ITaskEngineClient taskEngineClient, ICacheService redisService, IRouterClient routerClient, IContextFacadeService contextService) {
        this.iamClient = iamClient;
        this.executionClient = executionClient;
        this.scwokerClient = scwokerClient;
        this.taskEngineClient = taskEngineClient;
        this.redisService = redisService;
        this.routerClient = routerClient;
        this.contextService = contextService;
    }

    @Override
    public ResultDto executeCdc(MonitorRuleCdcModel monitorRuleCdcModel, EocDto eocDto, JSONArray monitorData) {
        if ("serviceComposer".equalsIgnoreCase(monitorRuleCdcModel.getActionType())) {
            this.initLocale();
            return this.scwokerClient.processService(monitorRuleCdcModel.getActionId(), monitorRuleCdcModel.getTenantId(), eocDto, monitorData);
        }
        if ("task".equalsIgnoreCase(monitorRuleCdcModel.getActionType())) {
            this.initLocale();
            return this.taskEngineClient.createProject(monitorRuleCdcModel.getActionId(), eocDto, monitorData);
        }
        Map<String, Object> param = MonitorHelper.buildCdcExecutionParam(monitorRuleCdcModel, eocDto, monitorData);
        return this.executionClient.callExecution(param, true);
    }

    private void initLocale() {
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (StringUtil.isBlank(locale)) {
            locale = this.iamClient.getDefaultLocale();
            DWServiceContext.getContext().getRequestHeader().put("locale", locale);
        }
    }

    @Override
    public ResultDto executeDeliver(JSONObject recordJsonObject) {
        JSONObject after = ObjectUtils.isEmpty((Object)recordJsonObject.getJSONObject("after")) ? recordJsonObject.getJSONObject("before") : recordJsonObject.getJSONObject("after");
        String tenantId = after.getString("tenant_id");
        String tenantSid = after.getString("tenantsid");
        if (StringUtils.isEmpty((CharSequence)tenantId) && StringUtils.isEmpty((CharSequence)tenantSid)) {
            LOGGER.error("\u63a5\u6536CDC\u7684\u8f6c\u53d1\u6d88\u606f\u4e2d\u6ca1\u6709tenantId\u6216\u8005tenantSid\uff0c\u8be5\u53d8\u5316\u7684\u6570\u636e\u65e0\u6cd5\u5904\u7406");
        } else {
            if (StringUtils.isEmpty((CharSequence)tenantId)) {
                LOGGER.info("\u63a5\u6536CDC\u7684\u8f6c\u53d1\u6d88\u606f\u4e2d\u6709tenantSid:{}", (Object)tenantSid);
                String redisKey = MonitorHelper.buildCdcTsid(tenantSid);
                if (this.redisService.hasKey(redisKey)) {
                    tenantId = (String)this.redisService.get(redisKey);
                } else {
                    JSONObject tenantJsonObject = this.iamClient.getTenantId(tenantSid);
                    if (Objects.isNull(tenantJsonObject) || StringUtils.isEmpty((CharSequence)tenantJsonObject.getString("tenantId"))) {
                        LOGGER.error("\u6839\u636etenantSid\u4eceIAM\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u4fe1\u606f\uff0ctenantSid={}", (Object)tenantSid);
                        return ResultHelper.generateSuccessResult("");
                    }
                    tenantId = tenantJsonObject.getString("tenantId");
                    this.redisService.set(redisKey, tenantId, FieldConstant.CDCTSID_EXPIRE);
                }
            } else {
                LOGGER.info("\u63a5\u6536CDC\u7684\u8f6c\u53d1\u6d88\u606f\u4e2d\u6709tenantId:{}", (Object)tenantId);
            }
            try {
                this.contextService.constructContext(tenantId);
                this.routerClient.deliver(JSON.toJSONString((Object)recordJsonObject), tenantId);
            }
            catch (Throwable e) {
                LOGGER.error("\u5904\u7406\u6d88\u606f\u6784\u5efa\u4e0a\u4e0b\u6587\u5931\u8d25\uff0ctenantId={}\uff0c\u5f02\u5e38:[{}]", (Object)recordJsonObject.getString("tenantId"), (Object)e);
                return ResultHelper.generateFailResult("\u6267\u884c\u8def\u7531\u5206\u53d1\u5931\u8d25");
            }
        }
        return ResultHelper.generateSuccessResult("");
    }
}

