/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.ops.impl;

import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.client.response.ActionMetaDataRes;
import com.digiwin.athena.cdme.service.facade.ops.IMonitorValidationFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorValidationFacadeService")
public class MonitorValidationFacadeService
implements IMonitorValidationFacadeService {
    @Autowired
    private IThemeMapClient iThemeMapClient;
    @Autowired
    private IScwokerClient iScwokerClient;

    @Override
    public boolean existActiveProject(String actionId, String tenantId, EocDto eocDto) {
        ResultDto validResult = this.validParam(actionId, tenantId);
        if (MonitorHelper.isResultFail(validResult)) {
            throw new BusinessException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        ActionMetaDataRes actionMetaDataRes = this.iThemeMapClient.getActionMetaData(actionId);
        if (!"START_SERVICECOMPOSER".equals(actionMetaDataRes.getType())) {
            return false;
        }
        return this.iScwokerClient.existActiveProject(actionMetaDataRes.getServiceComposerId(), tenantId, eocDto);
    }

    private ResultDto validParam(String actionId, String tenantId) {
        if (StringUtil.isBlank(actionId)) {
            return ResultHelper.generateFailResult("actionId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank(tenantId)) {
            return ResultHelper.generateFailResult("tenantId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return ResultHelper.generateSuccessResult(null);
    }
}

