/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.AbstractCreateRuleService;
import com.digiwin.athena.cdme.service.facade.rulesync.IRuleExtensionService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ILockService;
import java.util.concurrent.locks.Lock;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cdmeCREATED")
public class CreateService
extends AbstractCreateRuleService
implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateService.class);
    private final ILockService lockService;

    public CreateService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IThemeMapClient themeMapClient, IScheduleClient scheduleClient, IEspClient espClient, IRuleExtensionService ruleExtensionService, ILockService lockService) {
        super(ruleTriggerOperatorFacadeService, themeMapClient);
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="cdmeTransactionManager")
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("\u521b\u5efaCDC\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2: {}", (Object)ruleDto);
        RLock lock = this.lockService.lock(MonitorHelper.buildRedisKey(ruleDto.getTenantId(), ruleDto.getRuleId(), ruleDto.getEocMap()), MonitorHelper.buildOldRedisKey(ruleDto.getTenantId(), ruleDto.getRuleId(), ruleDto.getEocMap()));
        try {
            ResultDto<MonitorRuleDto> saveResult = this.saveRule(ruleDto.getTenantId(), ruleDto.getEocMap(), ruleDto.getRuleId(), ruleDto.getEnableStatus());
            if (MonitorHelper.isResultFail(saveResult)) {
                throw new BusinessException(saveResult.getCode(), saveResult.getMessage());
            }
            LOGGER.info("\u521b\u5efaCDC\u7c7b\u578b\u89c4\u5219\u6210\u529f\uff01");
            ResultDto resultDto = ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
            return resultDto;
        }
        finally {
            this.lockService.unlock((Lock)lock);
        }
    }
}

