/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorRuleMapper;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorRuleService")
public class MonitorRuleService
extends AbstractRepositorService<CdmeMonitorRuleMapper, MonitorRuleModel>
implements IMonitorRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRuleService.class);

    public MonitorRuleService(CdmeMonitorRuleMapper mapper) {
        super(mapper);
    }

    @Override
    public boolean editPageSizeByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto, Integer pageSize) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        int result = ((CdmeMonitorRuleMapper)this.mapper).update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(MonitorRuleModel::getRuleId, (Object)ruleId)).eq(MonitorRuleModel::getTenantId, (Object)tenantId)).eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleModel::getEocSiteId, (Object)eocSiteId)).eq(MonitorRuleModel::getIsEnable, (Object)"ENABLED")).set(MonitorRuleModel::getPageSize, (Object)pageSize));
        if (result < 1) {
            LOGGER.error("sd_monitor_rule\u8868\u66f4\u65b0pageSize = {} \u5931\u8d25\uff01", (Object)pageSize);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        int result = ((CdmeMonitorRuleMapper)this.mapper).delete((Wrapper)this.queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto));
        if (result < 1) {
            LOGGER.error("sd_monitor_rule\u8868\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u6761\u4ef6ruleId:{},tenantId:{},eoc:{}", new Object[]{ruleId, tenantId, eocDto});
            return false;
        }
        return true;
    }

    @Override
    public List<MonitorRuleModel> listByRuleIdAndTenantId(String ruleId, String tenantId) {
        return ((CdmeMonitorRuleMapper)this.mapper).selectList((Wrapper)this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId).eq(MonitorRuleModel::getIsEnable, (Object)"ENABLED"));
    }

    @Override
    public MonitorRuleModel getByRuleIdAndTenantIdAndTriggerId(String ruleId, String tenantId, String triggerId) {
        return (MonitorRuleModel)((CdmeMonitorRuleMapper)this.mapper).selectOne((Wrapper)((LambdaQueryWrapper)this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId).eq(MonitorRuleModel::getTriggerId, (Object)triggerId)).eq(MonitorRuleModel::getIsEnable, (Object)"ENABLED"));
    }

    @Override
    public MonitorRuleModel getByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleModel> wrapper = this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocCompanyId, (Object)eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocSiteId, (Object)eocSiteId);
        }
        wrapper.eq(MonitorRuleModel::getIsEnable, (Object)"ENABLED");
        return (MonitorRuleModel)((CdmeMonitorRuleMapper)this.mapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<MonitorRuleModel> listByTenantIdAndEoc(String tenantId, EocDto eocDto) {
        return ((CdmeMonitorRuleMapper)this.mapper).selectList((Wrapper)((LambdaQueryWrapper)this.queryWrapperByEocmap(eocDto).eq(MonitorRuleModel::getTenantId, (Object)tenantId)).orderByAsc(MonitorRuleModel::getRuleId));
    }

    @Override
    public List<MonitorRuleModel> listByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        return ((CdmeMonitorRuleMapper)this.mapper).selectList((Wrapper)this.queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto));
    }

    @Override
    public MonitorRuleModel getRuleByRuleIdAndTenantIdAndEocIgnoreIsEnable(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleModel> wrapper = this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocCompanyId, (Object)eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocSiteId, (Object)eocSiteId);
        }
        return (MonitorRuleModel)((CdmeMonitorRuleMapper)this.mapper).selectOne((Wrapper)wrapper);
    }

    private LambdaQueryWrapper<MonitorRuleModel> queryWrapperByRuleIdAndTenantIdAndEocmap(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return (LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperByRuleIdAndTenantId(ruleId, tenantId).eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleModel::getEocSiteId, (Object)eocSiteId);
    }

    private LambdaQueryWrapper<MonitorRuleModel> queryWrapperByEocmap(EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleModel::getEocSiteId, (Object)eocSiteId);
    }

    private LambdaQueryWrapper<MonitorRuleModel> queryWrapperByRuleIdAndTenantId(String ruleId, String tenantId) {
        return (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorRuleModel::getRuleId, (Object)ruleId)).eq(MonitorRuleModel::getTenantId, (Object)tenantId);
    }
}

