/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorTriggerInsMapper;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerInsService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorTriggerInsService")
public class MonitorTriggerInsService
extends AbstractRepositorService<CdmeMonitorTriggerInsMapper, MonitorTriggerInsModel>
implements IMonitorTriggerInsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTriggerInsService.class);

    public MonitorTriggerInsService(CdmeMonitorTriggerInsMapper mapper) {
        super(mapper);
    }

    @Override
    public List<MonitorTriggerInsModel> listByTriggerId(String triggerId) {
        return ((CdmeMonitorTriggerInsMapper)this.mapper).selectList((Wrapper)Wrappers.lambdaQuery().eq(MonitorTriggerInsModel::getTriggerId, (Object)triggerId));
    }

    @Override
    public boolean editByTriggerId(String triggerId, MonitorTriggerInsModel updateBean) {
        int result = ((CdmeMonitorTriggerInsMapper)this.mapper).update(updateBean, (Wrapper)Wrappers.lambdaUpdate().eq(MonitorTriggerInsModel::getTriggerId, (Object)triggerId));
        if (result < 1) {
            LOGGER.error("ins\u66f4\u65b0\u5931\u8d25\uff0c\u66f4\u65b0\u53c2\u6570{},triggerId:{}", (Object)JsonUtil.getJsonString(updateBean), (Object)triggerId);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteByTriggerId(String triggerId) {
        int result = ((CdmeMonitorTriggerInsMapper)this.mapper).delete((Wrapper)Wrappers.lambdaQuery().eq(MonitorTriggerInsModel::getTriggerId, (Object)triggerId));
        if (result < 1) {
            LOGGER.error("ins\u5220\u9664\u5931\u8d25\uff0ctriggerId:{}", (Object)triggerId);
            return false;
        }
        return true;
    }

    @Override
    public MonitorTriggerInsModel getByTriggerIdAndCompanyIdAndSiteId(String triggerId, String eocCompanyId, String eocSiteId) {
        return (MonitorTriggerInsModel)((CdmeMonitorTriggerInsMapper)this.mapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorTriggerInsModel::getTriggerId, (Object)triggerId)).eq(StringUtil.isNotBlank(eocCompanyId), MonitorTriggerInsModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorTriggerInsModel::getEocSiteId, (Object)eocSiteId));
    }

    @Override
    public boolean saveOrEdit(MonitorTriggerInsModel ins) {
        if (null == ins.getId()) {
            return this.save(ins);
        }
        return this.edit(ins);
    }
}

