package com.digiwin.athena.cdme;

import com.digiwin.loadbalance.scan.DWPathScan;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author wangbaojun
 * @since 2025/7/30
 */

@ComponentScan(basePackages = {"com.digiwin.gateway", "com.digiwin.athena.cdme"})
@EnableScheduling
@EnableAsync
@EnableRetry
@SpringBootApplication
@DWPathScan(basePackage = "com.digiwin.athena.*")
public class CdmeAppBoot {
    public static void main(String[] args) throws Throwable {
        JaNotify.notifyRun(() -> {
            SpringApplication springApplication = new SpringApplication(CdmeAppBoot.class);
            springApplication.addListeners(
                new ApplicationPidFileWriter("DWApiGatewayApplication.pid"));
            springApplication.run(args);
        });
        }
    }

