package com.digiwin.athena.cdme.constant;

/**
 * @description: 按服务划分各种参数定义的区域使用, 包含各种返回的JSONObject以及请求定义的map中的key值的定义处
 * @author: renwm
 * @date: 2020/4/27 9:08
 */
public final class FieldConstant {
    private FieldConstant() {
    }

    /*********************** theme map 侧传过来的参数定义开始 **************************/
    public static final String ACTION_ID = "action_id";
    public static final String ACTION_TYPE = "action_type";
    public static final String PRODUCT_NAME = "product_name";
    public static final String EXECUTE_PAGE_SIZE = "execute_page_size";
    public static final String STANDARD_POLLING_RULES = "standard_polling_rules";
    public static final String MONITOR_ACTION_ID = "monitor_action_id";
    public static final String CATEGORY = "category";
    public static final String MONITOR_TYPE = "monitor_type";
    public static final String IS_CONTINUE = "is_continue";
    public static final String IS_POLLING_IDS = "is_polling_ids";
    public static final String IS_DEDUPLICATION = "is_deduplication";
    public static final String RULE_EXTENSION = "extension";
    public static final String BK_INFO = "bk_info";
    public static final String RETURN_COLUMNS = "return_columns";
    public static final String EOC_LEVEL = "eocLevel";
    public static final String JOIN_PARAMS = "join_params";
    public static final String ALIAS = "alias";
    public static final String TABLE = "table";
    public static final String MQTT_SOURCE = "mqttSource";
    public static final String MQTT_TOPIC = "mqttTopic";
    public static final String CONVERSION_FILTER_CONDITION = "conversionFilterCondition";

    //侦测间隔时间
    public static final String CHILL_INTERVAL = "chill_interval";
    /**
     * FIXME product_uid节点不再使用
     */
    public static final String PRODUCT_UID = "product_uid";
    public static final String DYNAMIC_PARAMS = "dynamic_params";
    public static final String STATIC_PARAMS = "static_params";
    public static final String DYNAMIC_CONDITION = "dynamic_condition";
    public static final String SCRIPT = "script";

    /**
     * 租户Id字段名称
     */
    public static final String TENANT_ID = "tenant_id";

    /**
     * 动态条件字段
     */
    public static final String RIGHT_VALUE_TYPE = "right_value_type";
    public static final String RIGHT = "right";
    public static final String ITEMS = "items";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String TARGET = "target";
    public static final String OP = "op";

    /*SCAN类型:param_type + time_type*/
    public static final String SCAN_PARAM_TYPE_DATE_START = "DATE_START";
    public static final String SCAN_PARAM_TYPE_DATE_END = "DATE_END";
    public static final String SCAN_PARAM_TYPE_DATE_TIME_START = "DATE_TIME_START";
    public static final String SCAN_PARAM_TYPE_DATE_TIME_END = "DATE_TIME_END";
    /*API类型:param_type + time_type*/
    public static final String API_PARAM_TYPE_DATE_START = "STRING_START";
    public static final String API_PARAM_TYPE_DATE_END = "STRING_END";

    /*执行action的类型*/
    public static final String TASK_ACTION = "task";
    public static final String SERVICECOMPOSER_ACTION = "serviceComposer";

    /*动态时间区间常量*/
    public static final String LAST_MONITOR_TIME = "last_monitor_time";
    public static final String MONITOR_TIME = "monitor_time";

    /**
     * redis key前缀
     */
    public static final String REDIS_KEY_PREFIX = "monitor";
    public static final String REDIS_LOCK_KEY_PREFIX = "monitorengine:";
    /**
     * redis cdc key前缀
     * 2023 S12之前用的key monitor-cdc
     */
    public static final String REDIS_CDC_KEY_PREFIX = "cdme-cdc";

    /**
     * redis cdc topic 路由关系 key前缀
     *
     */
    public static final String REDIS_CDC_TOPIC_ROUTE_KEY_PREFIX = "monitorCDC_TopicRelationship";

    /**
     * redis cdc tenantsid 和 tenantid 映射关系
     *
     */
    public static final String REDIS_CDC_TENANTSID_PREFIX = "monitorCDC_TSID";

    /**
     * 间隔限制redis key前缀
     */
    public static final String INTERVAL_KEY_PREFIX = "monitoring";

    public static final String CONFIG = "config";
    /**
     * eoc信息
     */
    public static final String EOCMAP = "eocMap";
    /*********************** theme map 侧传过来的参数定义结束 **************************/

    /*********************** 调用排程以及执行接口定义的接口参数开始 **************************/
    public static final String RULEID = "ruleId";
    /**
     * 执行ID
     */
    public static final String ACTIONID = "actionId";
    public static final String TRIGGERS = "triggers";
    public static final String TENANTID = "tenantId";
    /**
     * 调用执行引擎参数
     */
    public static final String EXECUTION_PARAMS = "paras";
    public static final String EXECUTION_EOC_MAP = "eocMap";
    public static final String EXECUTION_SYS_PARAM = "sysParam";
    /*********************** 调用排程以及执行接口定义的接口参数结束 **************************/

    /*********************** 调用IAM接口定义的接口参数开始 **************************/
    /**
     * IAM 登录 入参 secretKey 字段名称
     */
    public static final String SECRETKEY = "secretKey";
    /**
     * IAM 登录 入参 identityType 字段名称
     */
    public static final String IDENTITYTYPE = "identityType";
    /**
     * IAM token  字段名称
     */
    public static final String USER_TOKEN = "token";
    /**
     * 租户sid 字段名称；是tenantSid依據tenantid產生的流水識別碼
     */
    public static final String TENANTSID = "tenantSid";
    /*********************** 调用IAM接口定义的接口参数结束 **************************/

    /*********************** 调用ESP data.get.change接口定义的接口参数开始 **************************/
    /**
     * esp  std_data 字段名
     */
    public static final String ESP_STD_DATA = "std_data";
    /**
     * esp  parameter字段名
     */
    public static final String ESP_PARAMETER = "parameter";
    /**
     * esp  request_objects 字段名
     */
    public static final String ESP_REQUEST_OBJECTS = "request_objects";
    /**
     * esp  response_objects 字段名
     */
    public static final String ESP_RESPONSE_OBJECTS = "response_objects";
    public static final String ESP_META_INFO = "meta_info";
    /**
     * esp  change_objects 字段名
     */
    public static final String ESP_CHANGE_OBJECTS = "change_objects";
    /**
     * esp  execution字段名
     */
    public static final String ESP_EXECUTION = "execution";
    /**
     * esp  code字段名
     */
    public static final String ESP_CODE = "code";
    /**
     * esp  description字段名
     */
    public static final String ESP_DESCRIPTION = "description";
    /**
     * esp  dispatch字段名
     */
    public static final String DISPATCH = "dispatch";
    /**
     * esp  version字段名
     */
    public static final String VERSION = "version";
    /*********************** 调用ESP data.get.change接口定义的接口参数结束 **************************/

    /*********************** 其他参数开始 **************************/
    public static final String RULE_ID = "rule_id";
    public static final String PROD_NAME = "prod_name";

    /**
     * 排程服务返回的数据字典名称
     */
    public static final String DATA = "data";
    public static final String ENABLE_STATUS = "enable_status";
    public static final String ENABLE_STATUS_N = "N";
    public static final String ENABLE_STATUS_Y = "Y";
    /*********************** 其他参数结束 **************************/

    /**
     * 平台返回响应结果 response 字段名称
     */
    public static final String DW_SERVICE_RESPONSE = "response";
    public static final String DW_SERVICE_STATUS = "status";
    public static final String DW_SERVICE_ERRORMESSAGE = "errorMessage";
    public static final String EOCCOMPANYID = "eocCompanyId";
    public static final String EOCSITEID = "eocSiteId";
    public static final String EOCREGIONID = "eocRegionId";
    public static final String EOC_COMPANY_ID = "eoc_company_id";
    public static final String EOC_SITE_ID = "eoc_site_id";
    public static final String EOC_REGION_ID = "eoc_region_id";

    /**
     * 运维接口获取MD5加密干扰串类型
     */
    public static final String SECURE_TYPE_MONITOROPS = "MonitorOpsService";
    public static final String SECURE_TYPE_REDISOPS = "RedisOperationService";

    /**
     * 对外api接口参数字段定义开始处
     */
    public static final String EAI_PROD = "prod";
    public static final String EAI_ID = "id";

    /**
     * EAI请求标头中的digi-service
     */
    public static final String EAI_DIGI_SERVICE = "digi-service";
    /**
     * EAI请求标头中的digi-eocmap
     */
    public static final String EAI_DIGI_EOC_MAP = "digi-eocmap";
    /** 对外api接口参数字段定义结束 */

    /**
     * 下发请求headers中塞入的routerkey参数
     */
    public static final String ROUTER_KEY = "routerKey";
    /**
     * 下发请求headers中塞入的语言别参数
     */
    public static final String LOCALE = "locale";
    /**
     * 同步侦测规则返回结果定义
     */
    public static final String MONITOR_RULE_EXIST = "参数对应的侦测规则信息已存在";
    public static final String MONITOR_RULE_NOT_EXIST = "参数没有对应的正在侦测的规则信息";
    /**
     * 查询排程信息返回结果定义
     **/
    public static final String SCHEDULE_NOT_EXIST = "SCHEDULE_NOT_EXIST";
    public static final String SCHEDULE_IS_ENABLED = "SCHEDULE_IS_ENABLED";

    /**
     * 侦测同步
     */
    public static final String OPERATE_TYPE_SYNC = "SYNC";
    /**
     * 侦测设置
     */
    public static final String OPERATE_TYPE_SET = "SET";

    /**
     * MQ方式
     */
    public static final String OPERATE_MODE_MQ = "MQ";
    /**
     * API方式
     */
    public static final String OPERATE_MODE_API = "API";
    /**
     * 设置回溯日期
     */
    public static final String TRACK_BACK_TIME = "TRACK_BACK_TIME";
    /**
     * 设置分页
     */
    public static final String PAGE_SIZE = "PAGE_SIZE";
    /**
     * 跨层级修改侦测规则
     */
    public static final String CROSS_LEVEL = "CROSS_LEVEL";
    /**
     * 应用过期：对应所属的侦测规则
     */
    public static final String RULE_EXPIRE = "RULE_EXPIRE";

    /**
     * 调用中间件租户token header名称
     */
    public static final String DW_TENANT_TOKEN_HEADER_NAME = "digi-middleware-auth-user";
    /**
     * 调用中间件应用 token header名称
     */
    public static final String DW_APP_TOKEN_HEADER_NAME = "digi-middleware-auth-app";
    /**
     * 过期应用appCode
     */
    public static final String APPCODE = "appCode";
    /**
     * 续期处理类型：renew/expire/clean
     */
    public static final String EVENT_TYPE = "eventType";

    /**
     * 续期类型
     */
    public static final String EVENT_TYPE_RENEW = "renew";
    public static final String EVENT_TYPE_EXPIRE = "expire";
    public static final String EVENT_TYPE_CLEAN = "clean";

    /**
     * 调用kg获取过期应用的组件名称
     */
    public static final String EXPIRE_COMPONENT = "MonitorRule";

    /**
     * CDC相关
     */
    public static final String DATA_AFTER = "after";
    public static final String DATA_BEFORE = "before";
    public static final String DATA_LEFT = "left";
    public static final String DATA_RIGHT = "right";
    public static final String TENANT_SID = "tenantsid";
    public static final String DATA_SOURCE = "source";
    public static final String DATA_TABLE = "table";
    public static final String DATA_DB = "db";
    public static final String DATA_OP = "op";
    public static final String DATA_ENABLED = "ENABLED";
    public static final String DATA_NAME = "name";
    public static final String DATA_VALUE = "value";
    public static final String OP_UPDATE = "u";
    public static final String OP_CREATE = "c";
    public static final String OP_DELETE = "d";
    public static final String CHANGE_TYPE_UPDATE = "update";
    public static final String CHANGE_TYPE_CREATE = "create";
    public static final String CHANGE_TYPE_DELETE = "delete";
    // 查询到的tenantsid和tenantid关系，记录到redis，过期时间为1个月
    public static final Integer CDCTSID_EXPIRE = 60*60*24*30;

}
