package com.digiwin.athena.cdme.constant;

/**
 * @description: 服务间常量定义处
 * @author: renwm
 * @date: 2020/4/28 14:02
 */
public final class FieldValConstant {
    private FieldValConstant() {
    }

    /**
     * 当前模组名称
     */
    public static final String CURRENT_MODULE_NAME = "MonitorEngine";

    /**
     * 服务返回成功状态码值
     */
    public static final int RESPONSE_SUCCESS_CODE = 200;
    /**
     * 第一行下标
     */
    public static final int START_POS = 0;

    /**
     * param_target类型定义
     */
    public static final String TARGET_SCAN = "SCAN";
    public static final String TARGET_MONITOR_ACTION = "MONITOR_ACTION";
    public static final String TARGET_ACTION = "ACTION";

    /**
     * category 类型定义处
     */
    public static final String CATEGORY_SCAN = "cdmeSCAN";
    public static final String CATEGORY_API = "cdmeAPI";
    public static final String CATEGORY_SCHEDULE = "cdmeSCHEDULE";
    public static final String CATEGORY_REPORT = "cdmeREPORT";
    public static final String CATEGORY_CDC = "CDC";
    public static final String CATEGORY_SQL_SCRIPT = "cdmeSQL_SCRIPT";
    public static final String CATEGORY_CHECKSUM = "cdmeCHECK_SUM";
    public static final String CATEGORY_MQTT = "MQTT";


    /**
     * 调用发起类型
     */
    public static final String POST_TYPE_SYS = "sys";
    public static final String POST_TYPE_USER = "user";

    /**
     * 侦测结果状态定义处: 侦测失败: 100; 侦测成功,无返回值,状态为:110; 侦测成功,有返回值,状态为:111
     */
    public static final String MONITOR_SCHEDULE_IGNORE = "000";
    public static final String MONITOR_INVOKE_FAIL = "100";
    public static final String MONITOR_RETURN_EMPTY = "110";
    public static final String MONITOR_RETURN_NOT_EMPTY = "111";
    public static final String ACTION_NOT_GO_ON = "000";

    public static final String DATA_CHANGE_PROCESS = "data.change.process";
    public static final String SERVICE_DATA_CHANGE_PROCESS = "service.data.change.process";

    public static final String EAI_SUCCESS_CODE = "0";
    public static final String EAI_FAIL_CODE = "-1";
    /** 对外开发接口相关常量定义处相应参数结束 */

    /**
     * 死信类型
     */
    public static final String DEAD_LETTER_TYPE_RULE = "rule";
    public static final String DEAD_LETTER_TYPE_MONITOR = "monitor";

    /**
     * 同步规则类型
     */
    public static final String MONITOR_RULE_CREATE = "cdmeCREATED";
    public static final String MONITOR_RULE_DELETED = "cdmeDELETED";
    public static final String MONITOR_RULE_DISABLED = "cdmeDISABLED";
    public static final String MONITOR_RULE_ENABLED = "cdmeENABLED";
    public static final String MONITOR_RULE_MODIFIED = "cdmeMODIFIED";

    /**
     * 调用执行引擎action类型
     */
    public static final String EXECUTE_TYPE_MONITOR_ACTION = "monitorAction";
    public static final String EXECUTE_TYPE_ACTION = "action";

    /**
     * ACTION类型类型 //NOTE 临时功能-1764
     */
    public static final String ACTION_TYPE_SCWORKER = "START_SERVICECOMPOSER";

    /**
     * 侦测规则enable状态
     */
    public static final String RULE_ENABLE = "ENABLED";
    public static final String RULE_DISABLE = "DISABLED";

    /**
     * 规则扩展配置事件枚举
     */
    public static final String DETECT_AFTER_CREATE = "detect_after_create";

    /**
     * ESP API
     */
    public static final String DATA_CHANGE_GET = "data.change.get";
    public static final String DATA_CHANGE_SQL_GET = "data.change.sql.get";

    /**
     * IAM 异常
     */
    public static final String IAM_TENANT_EXPIRE = "411004";
}
